/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.integration;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.Identifier;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.Destination;
import org.husky.communication.ConvenienceMasterPatientIndexV3;
import org.husky.communication.mpi.impl.PixV3Query;
import org.husky.communication.testhelper.TestApplication;
import org.husky.fhir.structures.gen.FhirCommon;
import org.husky.fhir.structures.gen.FhirPatient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, classes={TestApplication.class})
@EnableAutoConfiguration
class CHPixV3QueryPGTest {
    protected static Logger LOGGER = LoggerFactory.getLogger(CHPixV3QueryPGTest.class);
    @Autowired
    private ConvenienceMasterPatientIndexV3 convenienceMasterPatientIndexV3Client;
    @Autowired
    protected AuditContext auditContext;
    final String pixUri = "https://epdplayground.i4mi.bfh.ch:7443/PIXPDQ/services/PIXPDQV3ManagerService";
    final String facilityName = "Waldspital Bern";
    final String receiverApplicationOid = "1.1.1.99.1";
    final String senderApplicationOid = "1.2.3.4.123456";
    final String localAssigningAuthorityOid = "1.2.3.4.123456.1";
    final String localIdNamespace = "WALDSPITAL";
    final String localPatientId = "waldspital-Id-1234";
    final String spidAssigningAuthorityOid = "2.16.756.5.30.1.127.3.10.3";
    final String spidNamespace = "SPID";
    final String eprSpid = "761337637673823141";
    final String globalAssigningAuthorityOid = "1.1.1.99.1";
    final String globalPatientId = "2dc7a783-78b1-4627-94fb-610a23135c42";

    CHPixV3QueryPGTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        SpringApplication app = new SpringApplication(new Class[]{TestApplication.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.run(new String[0]);
    }

    @Test
    void queryTest() {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create("https://epdplayground.i4mi.bfh.ch:7443/PIXPDQ/services/PIXPDQV3ManagerService"));
        dest.setSenderApplicationOid("1.2.3.4.123456");
        dest.setReceiverApplicationOid("1.1.1.99.1");
        dest.setReceiverFacilityOid("Waldspital Bern");
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        PixV3Query pixV3Query = new PixV3Query(affinityDomain, "1.2.3.4.123456.1", "WALDSPITAL", "2.16.756.5.30.1.127.3.10.3", "SPID", this.convenienceMasterPatientIndexV3Client.getContext(), this.convenienceMasterPatientIndexV3Client.getAuditContext());
        Identifier localIdentifier = new Identifier();
        localIdentifier.setValue("waldspital-Id-1234");
        localIdentifier.setSystem(FhirCommon.addUrnOid((String)"1.2.3.4.123456.1"));
        FhirPatient patient = new FhirPatient();
        patient.getIdentifier().add(localIdentifier);
        ArrayList<String> queryDomainOids = new ArrayList<String>();
        queryDomainOids.add("2.16.756.5.30.1.127.3.10.3");
        queryDomainOids.add("1.1.1.99.1");
        List returnedIds = pixV3Query.queryPatientId(patient, queryDomainOids, null, null, null);
        Assertions.assertTrue((returnedIds.size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(returnedIds.get(0), (Object)"761337637673823141");
        Assertions.assertEquals(returnedIds.get(1), (Object)"2dc7a783-78b1-4627-94fb-610a23135c42");
    }
}

