/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.at.xd.storedquery;

import java.util.List;
import org.husky.common.at.enums.ClassCode;
import org.husky.common.at.enums.ConfidentialityCode;
import org.husky.common.at.enums.FormatCode;
import org.husky.common.at.enums.HealthcareFacilityTypeCode;
import org.husky.common.at.enums.PracticeSettingCode;
import org.husky.common.enums.DateTimeRangeAttributes;
import org.husky.common.enums.ValueSetEnumInterface;
import org.husky.common.model.Author;
import org.husky.common.model.Identificator;
import org.husky.common.utils.XdsMetadataUtil;
import org.husky.communication.xd.storedquery.DateTimeRange;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;

public class FindDocumentsQueryAt
extends org.husky.communication.xd.storedquery.FindDocumentsQuery {
    public FindDocumentsQueryAt(Identificator patientId, ClassCode[] classCodes, DateTimeRange[] dateTimeRanges, PracticeSettingCode[] practiceSettingCodes, HealthcareFacilityTypeCode[] healthCareFacilityCodes, ConfidentialityCode[] confidentialityCodes, FormatCode[] formatCodes, Author authorPerson, AvailabilityStatus status) {
        super(patientId, status);
        FindDocumentsQuery ipfStoredQuery = (FindDocumentsQuery)this.getIpfQuery();
        ipfStoredQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        ipfStoredQuery.setClassCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])classCodes));
        ipfStoredQuery.setPracticeSettingCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])practiceSettingCodes));
        ipfStoredQuery.setHealthcareFacilityTypeCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])healthCareFacilityCodes));
        ipfStoredQuery.setConfidentialityCodes(XdsMetadataUtil.convertEhcCodeToQueryListCode((ValueSetEnumInterface[])confidentialityCodes));
        ipfStoredQuery.setFormatCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])formatCodes));
        ipfStoredQuery.setStatus(List.of(status));
        if (dateTimeRanges != null) {
            for (int index = 0; index < dateTimeRanges.length; ++index) {
                if (dateTimeRanges[index] == null) continue;
                if (dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_START_TIME)) {
                    ipfStoredQuery.getServiceStartTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                    ipfStoredQuery.getServiceStartTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
                    continue;
                }
                if (dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_STOP_TIME)) {
                    ipfStoredQuery.getServiceStopTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                    ipfStoredQuery.getServiceStopTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
                    continue;
                }
                if (!dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.CREATION_TIME)) continue;
                ipfStoredQuery.getCreationTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                ipfStoredQuery.getCreationTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
            }
        }
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Author author = XdsMetadataUtil.converteHCAuthor((Author)authorPerson);
        ipfStoredQuery.setTypedAuthorPersons(List.of(author.getAuthorPerson()));
        this.setIpfStoredQuery((StoredQuery)ipfStoredQuery);
    }

    public void addConfidentialityCodes(ConfidentialityCode[] confidentialityCodes) {
        ((FindDocumentsQuery)this.getIpfQuery()).setConfidentialityCodes(XdsMetadataUtil.convertEhcCodeToQueryListCode((ValueSetEnumInterface[])confidentialityCodes));
    }
}

