/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.at;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.husky.common.at.AuthorAt;
import org.husky.common.at.enums.ClassCode;
import org.husky.common.at.enums.ConfidentialityCode;
import org.husky.common.at.enums.FormatCode;
import org.husky.common.at.enums.HealthcareFacilityTypeCode;
import org.husky.common.at.enums.MimeType;
import org.husky.common.at.enums.PracticeSettingCode;
import org.husky.common.at.enums.TypeCode;
import org.husky.common.at.utils.XdsMetadataUtilAt;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.enums.LanguageCode;
import org.husky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.husky.common.model.Author;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.common.model.Person;
import org.husky.common.utils.XdsMetadataUtil;
import org.husky.common.utils.time.DateTimes;
import org.husky.communication.at.CDAR2ExtractorAt;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ReferenceId;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMetadataAt
extends DocumentMetadata {
    private static Logger log = LoggerFactory.getLogger(DocumentMetadataAt.class);
    private static final String LANGUANGE_DE_AT = "de-AT";
    private List<Identificator> patientIds;
    private Identificator parentDocumentId;
    private AssociationType parentDocumentType;

    public DocumentMetadataAt() {
        super(LANGUANGE_DE_AT);
    }

    public DocumentMetadataAt(DocumentEntry documentEntryType, POCDMT000040ClinicalDocument cda, List<Identificator> patientIds) {
        super(cda, documentEntryType, LANGUANGE_DE_AT);
        this.patientIds = patientIds;
    }

    public DocumentMetadataAt(POCDMT000040ClinicalDocument cda, boolean urnOidNeeded) {
        super(cda, LANGUANGE_DE_AT);
        Instant serviceEventStop;
        Timestamp creationTime;
        List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Code> confidCodes;
        CDAR2ExtractorAt extractor = new CDAR2ExtractorAt(cda);
        this.setAvailabilityStatus(extractor.extractAvailabilityStatus());
        List authors = extractor.extractAuthors();
        if (authors != null) {
            for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Author author : authors) {
                this.getDocumentEntry().getAuthors().add(author);
            }
        }
        this.getDocumentEntry().setLegalAuthenticator(extractor.extractLegalAuthenticator());
        this.setTypeCode(extractor.extractClassCode(), extractor.extractTypeCode(), extractor.extractTypeCodeOfTranslation(), urnOidNeeded);
        this.setCodedLanguage(extractor.extractLanguageCode());
        LocalizedString comments = extractor.extractComments();
        if (comments != null) {
            this.setComments(extractor.extractComments().toString());
        }
        if ((confidCodes = extractor.extractConfidentialityCodes()) != null) {
            for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Code confCode : confidCodes) {
                this.getDocumentEntry().getConfidentialityCodes().add(confCode);
            }
        }
        if ((creationTime = extractor.extractCreationTime()) != null) {
            this.setCreationTime(creationTime.getDateTime());
        }
        this.getDocumentEntry().setFormatCode(extractor.extractFormatCode());
        this.getDocumentEntry().setHealthcareFacilityTypeCode(extractor.extractHealthCareFacilityTypeCode());
        this.setMetadataLanguage(extractor.extractLanguageCode());
        this.setMimeType(extractor.extractMimeType());
        Identifiable parentDoc = extractor.extractParentDocument();
        if (parentDoc != null) {
            this.setParentDocument(parentDoc, extractor.extractParentDocumentType());
        }
        this.getDocumentEntry().setSourcePatientInfo(extractor.extractSourcePatientInfo());
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Code eventCode = extractor.extractEventCode();
        this.getDocumentEntry().getEventCodeList().add(eventCode);
        Instant serviceEventStart = extractor.extractEventStartTime();
        if (serviceEventStart != null) {
            this.setServiceEventStartTime(DateTimes.getZonedDateTime((Instant)serviceEventStart));
        }
        if ((serviceEventStop = extractor.extractEventStopTime()) != null) {
            this.setServiceEventStopTime(DateTimes.getZonedDateTime((Instant)serviceEventStop));
        }
        this.patientIds = new ArrayList<Identificator>();
        List<Identifiable> cxPatientIds = extractor.extractPatientIds();
        for (Identifiable cx : cxPatientIds) {
            if (cx == null) continue;
            this.patientIds.add(XdsMetadataUtil.convertIpfIdentifiableToEhc((Identifiable)cx));
        }
        this.getDocumentEntry().setTitle(extractor.extractTitle());
        this.getDocumentEntry().getTitle().setLang(this.getMetadataLanguage());
        this.setUniqueId(extractor.extractUniqueId());
        this.setUri(extractor.extractURI());
    }

    private void setTypeCode(org.openehealth.ipf.commons.ihe.xds.core.metadata.Code classCode, org.openehealth.ipf.commons.ihe.xds.core.metadata.Code typeCode, org.openehealth.ipf.commons.ihe.xds.core.metadata.Code typeCodeFromTranslation, boolean urnOidNeeded) {
        if (typeCodeFromTranslation == null && typeCode != null && !TypeCode.isImmunizationHistory((String)typeCode.getCode())) {
            this.setClassCode(classCode, urnOidNeeded);
            this.getDocumentEntry().setTypeCode(typeCode);
        } else if (typeCodeFromTranslation != null && TypeCode.getEnum((String)typeCodeFromTranslation.getCode()) != null) {
            this.setClassCode(typeCode, urnOidNeeded);
            this.getDocumentEntry().setTypeCode(typeCodeFromTranslation);
        }
    }

    public void addAuthor(AuthorAt author, boolean orgUrnOidNeeded) {
        log.debug("organization id: {}", (Object)author.getOrganization().getIdentificatorList());
        super.addAuthor((Author)author);
        if (orgUrnOidNeeded) {
            for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Author authorDocEntry : this.getDocumentEntry().getAuthors()) {
                if (authorDocEntry == null || authorDocEntry.getAuthorInstitution() == null) continue;
                for (Organization orgDocEntry : authorDocEntry.getAuthorInstitution()) {
                    if (orgDocEntry == null || orgDocEntry.getAssigningAuthority() == null || orgDocEntry.getAssigningAuthority().getUniversalId() == null) continue;
                    orgDocEntry.getAssigningAuthority().setUniversalId(String.format("urn:oid:%s", orgDocEntry.getAssigningAuthority().getUniversalId()));
                }
            }
        }
    }

    public void addServiceEventCode(org.openehealth.ipf.commons.ihe.xds.core.metadata.Code code) {
        if (code != null) {
            this.getDocumentEntry().getEventCodeList().add(code);
        }
    }

    public ClassCode getClassCodeEnum() {
        return ClassCode.getEnum((String)this.getDocumentEntry().getClassCode().getCode());
    }

    public List<ConfidentialityCode> getConfidentialityCodesEnum() {
        ArrayList<ConfidentialityCode> ccl = new ArrayList<ConfidentialityCode>();
        if (!this.getDocumentEntry().getConfidentialityCodes().isEmpty()) {
            for (int i = 0; i < this.getDocumentEntry().getConfidentialityCodes().size(); ++i) {
                org.openehealth.ipf.commons.ihe.xds.core.metadata.Code cmt = (org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)this.getDocumentEntry().getConfidentialityCodes().get(i);
                ccl.add(ConfidentialityCode.getEnum((String)cmt.getCode()));
            }
        }
        return ccl;
    }

    public FormatCode getFormatCodeEnum() {
        return FormatCode.getEnum((String)this.getDocumentEntry().getFormatCode().getCode());
    }

    public HealthcareFacilityTypeCode getHealthcareFacilityTypeCodeEnum() {
        return HealthcareFacilityTypeCode.getEnum((String)this.getDocumentEntry().getHealthcareFacilityTypeCode().getCode());
    }

    public LanguageCode getLanguageCodeEnum() {
        return LanguageCode.getEnum((String)this.getDocumentEntry().getLanguageCode());
    }

    public Person getLegalAuthenticator() {
        return new Person(this.getDocumentEntry().getLegalAuthenticator());
    }

    public MimeType getMimeTypeCodeEnum() {
        return MimeType.getEnum((String)this.getDocumentEntry().getMimeType());
    }

    public PracticeSettingCode getPracticeSettingCodeEnum() {
        return PracticeSettingCode.getEnum((String)this.getDocumentEntry().getPracticeSettingCode().getCode());
    }

    public ReferenceId getRefrencedIdList() {
        List values;
        if (this.getDocumentEntry().getReferenceIdList() != null && (values = this.getDocumentEntry().getReferenceIdList()) != null && !values.isEmpty()) {
            return (ReferenceId)values.get(0);
        }
        return null;
    }

    public Code getServiceEventCode() {
        if (this.getDocumentEntry().getEventCodeList() != null && !this.getDocumentEntry().getEventCodeList().isEmpty() && this.getDocumentEntry().getEventCodeList().get(0) != null) {
            return XdsMetadataUtil.convertOhtCodedMetadataType((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)((org.openehealth.ipf.commons.ihe.xds.core.metadata.Code)this.getDocumentEntry().getEventCodeList().get(0)));
        }
        return null;
    }

    public ZonedDateTime getServiceEventStartTime() {
        if (this.getDocumentEntry().getServiceStartTime() != null) {
            return this.getDocumentEntry().getServiceStartTime().getDateTime();
        }
        return null;
    }

    public ZonedDateTime getServiceEventStopTime() {
        if (this.getDocumentEntry().getServiceStopTime() != null) {
            return this.getDocumentEntry().getServiceStopTime().getDateTime();
        }
        return null;
    }

    public Identificator getSetId() {
        return new Identificator(this.getCda().getSetId());
    }

    public TypeCode getTypeCodeEnum() {
        return TypeCode.getEnum((String)this.getDocumentEntry().getTypeCode().getCode());
    }

    public void setClassCode(org.openehealth.ipf.commons.ihe.xds.core.metadata.Code code, boolean urnOidNeeded) {
        if (code != null) {
            if (code.getSchemeName() != null && urnOidNeeded && !code.getSchemeName().contains("urn:oid:")) {
                code.setSchemeName(String.format("urn:oid:%s", code.getSchemeName()));
            }
            this.getDocumentEntry().setClassCode(code);
        }
    }

    public void setCodedLanguage(LanguageCode codedLanguage) {
        super.setCodedLanguage(codedLanguage.getCodeValue());
    }

    public void setComments(String comments) {
        this.getDocumentEntry().setComments(XdsMetadataUtil.createInternationalString((String)comments));
    }

    public void setMimeType(MimeType mimeType) {
        super.setMimeType(mimeType.getCodeValue());
    }

    public void setParentDocument(Identifiable id, AssociationType relationship) {
        if (id != null && relationship != null) {
            this.parentDocumentId = XdsMetadataUtil.convertIpfIdentifiableToEhc((Identifiable)id);
            this.parentDocumentType = relationship;
        }
    }

    public void removePatientIdsFromPatient() {
        if (this.getDocumentEntry().getSourcePatientInfo() != null && this.getDocumentEntry().getSourcePatientInfo().getIds() != null) {
            while (this.getDocumentEntry().getSourcePatientInfo().getIds().hasNext()) {
                this.getDocumentEntry().getSourcePatientInfo().getIds().next();
                this.getDocumentEntry().getSourcePatientInfo().getIds().remove();
            }
        }
    }

    public void setRefrencedIdList(Identificator id, String homeCommunityId) {
        ReferenceId referenceId = (ReferenceId)Hl7v2Based.parse((String)XdsMetadataUtilAt.createCxi((Identificator)id, (String)"urn:elga:iti:xds:2014:ownDocument_setId", (String)homeCommunityId), ReferenceId.class);
        this.getDocumentEntry().getReferenceIdList().add(referenceId);
    }

    public void setServiceEventStartTime(ZonedDateTime startDate) {
        if (startDate != null) {
            this.getDocumentEntry().setServiceStartTime(new Timestamp(startDate, null));
        }
    }

    public void setServiceEventStopTime(ZonedDateTime stopDate) {
        if (stopDate != null) {
            this.getDocumentEntry().setServiceStopTime(new Timestamp(stopDate, null));
        }
    }

    public void setServiceEventCode(List<Code> codes) {
        if (codes != null && !codes.isEmpty()) {
            for (Code eventCode : codes) {
                if (eventCode == null) continue;
                this.getDocumentEntry().getEventCodeList().add(XdsMetadataUtil.convertEhcCodeToCode((Code)eventCode));
            }
        }
    }

    public void setServiceEventCode(Code eventCode) {
        if (eventCode != null) {
            this.getDocumentEntry().getEventCodeList().add(XdsMetadataUtil.convertEhcCodeToCode((Code)eventCode));
        }
    }

    public void addConfidentialityCodeHl7Cdar2(ConfidentialityCode code) {
        if (code != null) {
            super.addConfidentialityCode(code.getCode());
        }
    }

    public Identificator getParentDocumentId() {
        return this.parentDocumentId;
    }

    public AssociationType getParentDocumentType() {
        return this.parentDocumentType;
    }

    public List<Identificator> getPatientIdsHl7Cdar2() {
        return this.patientIds;
    }

    public void setLegalAuthenticator(Person legalAuthenticator) {
        if (legalAuthenticator != null) {
            this.getDocumentEntry().setLegalAuthenticator(legalAuthenticator.getIpfPerson());
        }
    }

    public void setMetadata(DocumentMetadataAt metaData) {
        super.setMetadata((DocumentMetadata)metaData);
        this.setLegalAuthenticator(metaData.getLegalAuthenticator());
        this.setServiceEventCode(metaData.getServiceEventCode());
        this.setServiceEventStartTime(metaData.getServiceEventStartTime());
        this.setServiceEventStopTime(metaData.getServiceEventStopTime());
    }
}

