/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.at;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.husky.common.at.AuthorAt;
import org.husky.common.at.enums.ConfidentialityCode;
import org.husky.common.communication.AffinityDomain;
import org.husky.common.communication.AtnaConfig;
import org.husky.common.communication.DocumentMetadata;
import org.husky.common.communication.SubmissionSetMetadata;
import org.husky.common.enums.DocumentDescriptor;
import org.husky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.husky.common.model.Author;
import org.husky.common.model.Code;
import org.husky.common.model.Identificator;
import org.husky.common.utils.XdsMetadataUtil;
import org.husky.communication.ConvenienceCommunication;
import org.husky.communication.at.DocumentMetadataAt;
import org.husky.communication.exceptions.DocumentNotAccessibleException;
import org.husky.communication.xd.storedquery.AbstractStoredQuery;
import org.husky.communication.xd.storedquery.FindDocumentsQuery;
import org.husky.xua.core.SecurityHeaderElement;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvenienceCommunicationAt
extends ConvenienceCommunication {
    private static Logger log = LoggerFactory.getLogger(ConvenienceCommunicationAt.class);

    public ConvenienceCommunicationAt() {
        super(null);
    }

    public ConvenienceCommunicationAt(AffinityDomain affinityDomain) {
        super(affinityDomain);
    }

    public ConvenienceCommunicationAt(AffinityDomain affinityDomain, AtnaConfig.AtnaConfigMode atnaConfigMode, DocumentMetadata.DocumentMetadataExtractionMode documentMetadataExtractionMode, SubmissionSetMetadata.SubmissionSetMetadataExtractionMode submissionSetMetadataExtractionMode) {
        super(affinityDomain, atnaConfigMode, documentMetadataExtractionMode, submissionSetMetadataExtractionMode);
    }

    public DocumentMetadataAt addElgaDocument(DocumentDescriptor desc, InputStream inputStream, POCDMT000040ClinicalDocument cda, boolean urnOidNeeded) {
        DocumentMetadataAt metadata = null;
        if (inputStream == null) {
            try {
                throw new DocumentNotAccessibleException();
            }
            catch (DocumentNotAccessibleException e) {
                log.error(e.getMessage());
            }
        }
        this.clearDocuments();
        try {
            if (cda != null) {
                metadata = new DocumentMetadataAt(cda, urnOidNeeded);
            }
            Document doc = new Document();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(inputStream, desc.getMimeType());
            doc.setDataHandler(new DataHandler((DataSource)dataSource));
            metadata = this.addXdsDocument(doc, desc, metadata);
            log.debug("document entry uuid: {}, document unique id: {}", (Object)doc.getDocumentEntry().getEntryUuid(), (Object)doc.getDocumentEntry().getUniqueId());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return metadata;
    }

    protected DocumentMetadataAt addXdsDocument(Document doc, DocumentDescriptor desc, DocumentMetadataAt metadata) {
        this.clearDocuments();
        DocumentMetadataAt docMetadata = null;
        if (metadata != null) {
            docMetadata = new DocumentMetadataAt(metadata.getDocumentEntry(), metadata.getCda(), metadata.getPatientIdsHl7Cdar2());
            if (doc.getDocumentEntry() == null) {
                doc.setDocumentEntry(metadata.getDocumentEntry());
            }
        } else {
            log.warn("Document entry is null. No metadata known");
        }
        this.getTxnData().getDocuments().add(doc);
        if (docMetadata != null) {
            if (this.getAutomaticExtractionEnabled() == DocumentMetadata.DocumentMetadataExtractionMode.DEFAULT_EXTRACTION) {
                if (DocumentDescriptor.CDA_R2.equals((Object)desc)) {
                    this.fixDocEntryAttributes(doc, docMetadata, desc);
                }
                this.generateDefaultSubmissionSetAttributes();
            } else {
                docMetadata.clear();
            }
        }
        return docMetadata;
    }

    private void fixDocEntryAttributes(Document targetDoc, DocumentMetadataAt metadata, DocumentDescriptor desc) {
        if (targetDoc == null) {
            return;
        }
        DocumentMetadataAt docMetadata = new DocumentMetadataAt(targetDoc.getDocumentEntry(), metadata.getCda(), metadata.getPatientIdsHl7Cdar2());
        if (docMetadata.getDocumentEntry().getMimeType() == null) {
            docMetadata.setMimeType(desc.getMimeType());
        }
        if (docMetadata.getDocumentEntry().getUniqueId() == null) {
            docMetadata.getDocumentEntry().assignUniqueId();
        }
        if (docMetadata.getDocumentEntry().getCreationTime() == null) {
            docMetadata.setCreationTime(ZonedDateTime.now());
        }
        if (docMetadata.getDocumentEntry().getConfidentialityCodes().isEmpty()) {
            docMetadata.addConfidentialityCodeHl7Cdar2(ConfidentialityCode.NORMAL);
            log.debug("confidentiality code: {}", docMetadata.getDocumentEntry().getConfidentialityCodes().get(0));
        }
        if (!docMetadata.getDocumentEntry().getEventCodeList().isEmpty()) {
            log.debug("event codes: {}", docMetadata.getDocumentEntry().getEventCodeList().get(0));
        }
        if (docMetadata.getDocumentEntry().getClassCode() != null) {
            log.debug("class codes: {}", (Object)docMetadata.getDocumentEntry().getClassCode().getDisplayName());
        }
        if (docMetadata.getDocumentEntry().getUniqueId() != null) {
            log.debug("unique id: {}", (Object)docMetadata.getDocumentEntry().getUniqueId());
        }
    }

    public void generateSubmissionSetMetadata(Author author, Code contentTypeCode) {
        if (this.getTxnData().getSubmissionSet() == null) {
            this.getTxnData().setSubmissionSet(new SubmissionSet());
        }
        SubmissionSet subSet = this.getTxnData().getSubmissionSet();
        if (this.getTxnData().getDocuments() != null && !this.getTxnData().getDocuments().isEmpty()) {
            this.setSubSetDetailsForDocuments(subSet, author, contentTypeCode);
        }
    }

    private void setSubSetDetailsForDocuments(SubmissionSet subSet, Author author, Code contentTypeCode) {
        log.info("count of documents {}", (Object)this.getTxnData().getDocuments().size());
        for (Document document : this.getTxnData().getDocuments()) {
            DocumentEntry docEntry = document.getDocumentEntry();
            if (docEntry.getPatientId() == null) {
                throw new IllegalStateException("Missing destination patient ID in DocumentMetadata of first document.");
            }
            if (contentTypeCode != null) {
                subSet.setContentTypeCode(XdsMetadataUtil.convertEhcCodeToCode((Code)contentTypeCode));
            }
            if (subSet.getContentTypeCode() == null && docEntry.getTypeCode() != null) {
                subSet.setContentTypeCode(docEntry.getTypeCode());
            }
            this.setGeneralSubSetDetails(subSet, docEntry.getPatientId(), docEntry.getSourcePatientId());
            this.addAuthorToSubSet(subSet, author);
        }
    }

    private void addAuthorToSubSet(SubmissionSet subSet, Author author) {
        if (subSet.getAuthors().isEmpty()) {
            subSet.getAuthors().add(AuthorAt.getIpfAuthor((Author)author));
        }
        if (subSet.getAuthors() != null && !subSet.getAuthors().isEmpty()) {
            for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Author ipfAuthor : subSet.getAuthors()) {
                if (ipfAuthor == null) continue;
                this.fixAuthorInstitution(ipfAuthor.getAuthorInstitution());
                if (ipfAuthor.getAuthorRole() != null && !ipfAuthor.getAuthorRole().isEmpty() && ipfAuthor.getAuthorRole().get(0) == null) {
                    ipfAuthor.getAuthorRole().clear();
                }
                this.fixAuthorPerson(ipfAuthor.getAuthorPerson());
            }
        }
    }

    private void fixAuthorPerson(Person authorPerson) {
        if (authorPerson != null && authorPerson.getId() != null && authorPerson.getId().getAssigningAuthority() != null && authorPerson.getId().getAssigningAuthority().getUniversalId() != null && authorPerson.getId().getId() == null) {
            authorPerson.getId().setId(authorPerson.getId().getAssigningAuthority().getUniversalId());
            authorPerson.getId().setAssigningAuthority(null);
        }
    }

    private void fixAuthorInstitution(List<Organization> institutions) {
        if (institutions != null) {
            for (Organization authorXon : institutions) {
                if (authorXon == null || authorXon.getAssigningAuthority() == null || authorXon.getAssigningAuthority().getUniversalId() == null || authorXon.getIdNumber() != null) continue;
                authorXon.setIdNumber(authorXon.getAssigningAuthority().getUniversalId());
                authorXon.setAssigningAuthority(null);
            }
        }
    }

    protected void setGeneralSubSetDetails(SubmissionSet subSet, Identifiable patientId, Identifiable sourcePatientId) {
        if (subSet.getSubmissionTime() == null) {
            subSet.setSubmissionTime(new Timestamp(ZonedDateTime.now(), Timestamp.Precision.SECOND));
        }
        if (subSet.getEntryUuid() == null) {
            subSet.setEntryUuid(UUID.randomUUID().toString());
        }
        if (subSet.getUniqueId() == null || subSet.getSourceId() == null) {
            if (subSet.getUniqueId() == null) {
                subSet.assignUniqueId();
            }
            if (subSet.getSourceId() == null) {
                subSet.setSourceId(this.getSourceId(sourcePatientId));
            }
        }
        if (subSet.getPatientId() == null) {
            subSet.setPatientId(patientId);
        }
    }

    public QueryResponse queryDocumentReferencesOnly(Identificator patientId, SecurityHeaderElement assertion, String messageId) throws Exception {
        return this.queryDocumentReferencesOnly((AbstractStoredQuery)new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED), assertion, messageId);
    }

    public QueryResponse queryDocuments(Identificator patientId, SecurityHeaderElement assertion, String messageId) throws Exception {
        return this.queryDocuments((AbstractStoredQuery)new FindDocumentsQuery(patientId, AvailabilityStatus.APPROVED), assertion, messageId);
    }

    public Response submit(Author author, Code codeContentType, SecurityHeaderElement security, String messageId) throws Exception {
        this.generateSubmissionSetMetadata(author, codeContentType);
        return this.submit(security, messageId);
    }
}

