/*
 * Decompiled with CFR 0.152.
 */
package org.husky.communication.at;

import com.google.common.collect.Iterators;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.JAXBElement;
import org.husky.common.communication.CDAR2Extractor;
import org.husky.common.hl7cdar2.CD;
import org.husky.common.hl7cdar2.CE;
import org.husky.common.hl7cdar2.II;
import org.husky.common.hl7cdar2.IVLTS;
import org.husky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.husky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.husky.common.hl7cdar2.POCDMT000040PatientRole;
import org.husky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.husky.common.hl7cdar2.POCDMT000040RelatedDocument;
import org.husky.common.hl7cdar2.TS;
import org.husky.common.utils.time.DateTimes;
import org.husky.common.utils.time.Hl7Dtm;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;

public class CDAR2ExtractorAt
extends CDAR2Extractor {
    public CDAR2ExtractorAt(POCDMT000040ClinicalDocument cda) {
        super(cda);
    }

    public List<Code> extractConfidentialityCodes() {
        if (this.cda.getConfidentialityCode() == null) {
            return new LinkedList<Code>();
        }
        Code code = this.map((CD)this.cda.getConfidentialityCode());
        return List.of(code);
    }

    public Code extractEventCode() {
        if (!this.cda.getDocumentationOf().isEmpty()) {
            CE serviceEvent = ((POCDMT000040DocumentationOf)this.cda.getDocumentationOf().get(0)).getServiceEvent().getCode();
            return this.map((CD)serviceEvent);
        }
        return null;
    }

    public Instant extractEventStartTime() {
        IVLTS serviceEventTime;
        if (!this.cda.getDocumentationOf().isEmpty() && (serviceEventTime = ((POCDMT000040DocumentationOf)this.cda.getDocumentationOf().get(0)).getServiceEvent().getEffectiveTime()) != null) {
            for (JAXBElement element : serviceEventTime.getRest()) {
                if (element == null || element.getName() == null || element.getName().getLocalPart() == null || !element.getName().getLocalPart().equalsIgnoreCase("low") || !(element.getValue() instanceof TS)) continue;
                Hl7Dtm hl7Dtm = Hl7Dtm.fromHl7((String)((TS)element.getValue()).getValue());
                return DateTimes.toInstant((Hl7Dtm)hl7Dtm);
            }
        }
        return null;
    }

    public Instant extractEventStopTime() {
        IVLTS serviceEventTime;
        if (!this.cda.getDocumentationOf().isEmpty() && (serviceEventTime = ((POCDMT000040DocumentationOf)this.cda.getDocumentationOf().get(0)).getServiceEvent().getEffectiveTime()) != null) {
            for (JAXBElement element : serviceEventTime.getRest()) {
                if (element == null || element.getName() == null || element.getName().getLocalPart() == null || !element.getName().getLocalPart().equalsIgnoreCase("high") || !(element.getValue() instanceof TS)) continue;
                Hl7Dtm hl7Dtm = Hl7Dtm.fromHl7((String)((TS)element.getValue()).getValue());
                return DateTimes.toInstant((Hl7Dtm)hl7Dtm);
            }
        }
        return null;
    }

    public List<Identifiable> extractPatientIds() {
        if (!this.atLeastOne(this.cda.getRecordTarget())) {
            return new ArrayList<Identifiable>();
        }
        POCDMT000040RecordTarget target = (POCDMT000040RecordTarget)this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            return new ArrayList<Identifiable>();
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        if (!this.atLeastOne(patient.getId())) {
            return new ArrayList<Identifiable>();
        }
        return this.extractIds(patient.getId());
    }

    private List<Identifiable> extractIds(List<II> ids) {
        ArrayList<Identifiable> list = new ArrayList<Identifiable>();
        for (II id : ids) {
            if (id == null) continue;
            list.add(this.map(id));
        }
        return list;
    }

    public Code extractTypeCodeOfTranslation() {
        if (this.cda.getCode() == null) {
            return null;
        }
        if (this.cda.getCode().getTranslation().isEmpty()) {
            return null;
        }
        if (this.cda.getCode().getTranslation().get(0) == null || ((CD)this.cda.getCode().getTranslation().get(0)).getCode() == null) {
            return null;
        }
        if (this.cda.getCode().getTranslation().get(0) == null || ((CD)this.cda.getCode().getTranslation().get(0)).getCode() == null) {
            return null;
        }
        return this.map((CD)this.cda.getCode().getTranslation().get(0));
    }

    public Code extractTypeCode() {
        if (this.cda.getCode() == null) {
            return null;
        }
        return this.map((CD)this.cda.getCode());
    }

    public Code extractCode() {
        return this.extractTypeCode();
    }

    public Identifiable extractParentDocument() {
        if (!this.cda.getRelatedDocument().isEmpty() && this.cda.getRelatedDocument().get(0) != null && ((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getParentDocument() != null && !((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getParentDocument().getId().isEmpty() && ((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getParentDocument().getId().get(0) != null) {
            return this.map((II)((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getParentDocument().getId().get(0));
        }
        return null;
    }

    public AssociationType extractParentDocumentType() {
        if (!this.cda.getRelatedDocument().isEmpty() && this.cda.getRelatedDocument().get(0) != null && ((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getTypeCode() != null) {
            switch (((POCDMT000040RelatedDocument)this.cda.getRelatedDocument().get(0)).getTypeCode()) {
                case APND: {
                    return AssociationType.APPEND;
                }
                case RPLC: {
                    return AssociationType.REPLACE;
                }
                case XFRM: {
                    return AssociationType.TRANSFORM;
                }
            }
            return null;
        }
        return null;
    }

    public PatientInfo extractSourcePatientInfo() {
        PatientInfo patientInfo = super.extractSourcePatientInfo();
        ListIterator listIterator = patientInfo.getIds();
        int iteratorSize = Iterators.size((Iterator)listIterator);
        LinkedList<Identifiable> list = new LinkedList<Identifiable>();
        for (int index = 0; index < iteratorSize; ++index) {
            list.add(null);
        }
        while (listIterator.hasNext()) {
            Identifiable next = (Identifiable)listIterator.next();
            if (next.getAssigningAuthority() != null && "1.2.40.0.10.2.1.1.149".equalsIgnoreCase(next.getAssigningAuthority().getUniversalId())) {
                list.set(0, next);
                continue;
            }
            if (next.getAssigningAuthority() != null && "1.2.40.0.10.1.4.3.1".equalsIgnoreCase(next.getAssigningAuthority().getUniversalId())) {
                list.set(1, next);
                continue;
            }
            if (list.size() < 3) {
                list.add(next);
                continue;
            }
            list.set(2, next);
        }
        ListIterator listIt = patientInfo.getIds();
        while (listIt.hasNext()) {
            listIt.next();
            listIt.remove();
        }
        for (Identifiable id : list) {
            patientInfo.getIds().add(id);
        }
        return patientInfo;
    }
}

