/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.lw;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeConstantProvider;
import org.apache.camel.Experimental;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.GlobalEndpointConfiguration;
import org.apache.camel.IsSingleton;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.TypeConverter;
import org.apache.camel.ValueHolder;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.impl.converter.CoreTypeConverterRegistry;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DeferServiceFactory;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptEndpointFactory;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PeriodTaskResolver;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class LightweightRuntimeCamelContext
implements ExtendedCamelContext,
CatalogCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(LightweightRuntimeCamelContext.class);
    private final CamelContext reference;
    private final Registry registry;
    private final CoreTypeConverterRegistry typeConverter;
    private final ModelJAXBContextFactory modelJAXBContextFactory;
    private final ComponentResolver componentResolver;
    private final ComponentNameResolver componentNameResolver;
    private final LanguageResolver languageResolver;
    private final DataFormatResolver dataFormatResolver;
    private final HealthCheckResolver healthCheckResolver;
    private final DevConsoleResolver devConsoleResolver;
    private final UuidGenerator uuidGenerator;
    private final EndpointRegistry<? extends ValueHolder<String>> endpoints;
    private final Map<String, Component> components;
    private final Map<String, Language> languages;
    private final PropertiesComponent propertiesComponent;
    private final BeanIntrospection beanIntrospection;
    private final CamelBeanPostProcessor beanPostProcessor;
    private final CamelDependencyInjectionAnnotationFactory dependencyInjectionAnnotationFactory;
    private final HeadersMapFactory headersMapFactory;
    private final CliConnectorFactory cliConnectorFactory;
    private final ExchangeFactory exchangeFactory;
    private final ExchangeFactoryManager exchangeFactoryManager;
    private final ProcessorExchangeFactory processorExchangeFactory;
    private final ModelineFactory modelineFactory;
    private final ReactiveExecutor reactiveExecutor;
    private final AsyncProcessorAwaitManager asyncProcessorAwaitManager;
    private final ExecutorServiceManager executorServiceManager;
    private final ShutdownStrategy shutdownStrategy;
    private final ClassLoader applicationContextClassLoader;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private final RouteController routeController;
    private final ProcessorFactory processorFactory;
    private final InternalProcessorFactory internalProcessorFactory;
    private final InflightRepository inflightRepository;
    private final PeriodTaskResolver periodTaskResolver;
    private final PeriodTaskScheduler periodTaskScheduler;
    private final Injector injector;
    private final ClassResolver classResolver;
    private final Map<String, String> globalOptions;
    private final String name;
    private final String description;
    private final boolean eventNotificationApplicable;
    private final boolean useDataType;
    private final boolean useBreadcrumb;
    private final boolean dumpRoutes;
    private final String mdcLoggingKeysPattern;
    private final boolean useMDCLogging;
    private final String basePackageScan;
    private final List<Route> routes;
    private final boolean messageHistory;
    private final boolean allowUseOriginalMessage;
    private final boolean logExhaustedMessageBody;
    private final String version;
    private Date startDate;
    private StartupSummaryLevel startupSummaryLevel;

    LightweightRuntimeCamelContext(CamelContext reference, CamelContext context) {
        this.reference = reference;
        this.registry = context.getRegistry();
        this.typeConverter = new CoreTypeConverterRegistry(context.getTypeConverterRegistry());
        this.modelJAXBContextFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getModelJAXBContextFactory();
        this.routes = Collections.unmodifiableList(context.getRoutes());
        this.uuidGenerator = context.getUuidGenerator();
        this.componentResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getComponentResolver();
        this.componentNameResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getComponentNameResolver();
        this.languageResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getLanguageResolver();
        this.dataFormatResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getDataFormatResolver();
        this.healthCheckResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getHealthCheckResolver();
        this.devConsoleResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getDevConsoleResolver();
        this.endpoints = context.getEndpointRegistry();
        this.components = context.getComponentNames().stream().collect(Collectors.toMap(s -> s, arg_0 -> ((CamelContext)context).hasComponent(arg_0)));
        this.languages = context.getLanguageNames().stream().collect(Collectors.toMap(s -> s, arg_0 -> ((CamelContext)context).resolveLanguage(arg_0)));
        this.propertiesComponent = context.getPropertiesComponent();
        this.beanIntrospection = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        this.beanPostProcessor = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        this.dependencyInjectionAnnotationFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getDependencyInjectionAnnotationFactory();
        this.headersMapFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getHeadersMapFactory();
        this.cliConnectorFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getCliConnectorFactory();
        this.exchangeFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getExchangeFactory();
        this.exchangeFactoryManager = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getExchangeFactoryManager();
        this.modelineFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getModelineFactory();
        this.processorExchangeFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getProcessorExchangeFactory();
        this.reactiveExecutor = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.asyncProcessorAwaitManager = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getAsyncProcessorAwaitManager();
        this.executorServiceManager = context.getExecutorServiceManager();
        this.shutdownStrategy = context.getShutdownStrategy();
        this.applicationContextClassLoader = context.getApplicationContextClassLoader();
        this.unitOfWorkFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory();
        this.processorFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getProcessorFactory();
        this.internalProcessorFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory();
        this.routeController = context.getRouteController();
        this.inflightRepository = context.getInflightRepository();
        this.periodTaskResolver = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getPeriodTaskResolver();
        this.periodTaskScheduler = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getPeriodTaskScheduler();
        this.globalOptions = context.getGlobalOptions();
        this.injector = context.getInjector();
        this.classResolver = context.getClassResolver();
        this.name = context.getName();
        this.description = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getDescription();
        this.eventNotificationApplicable = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).isEventNotificationApplicable();
        this.useDataType = context.isUseDataType();
        this.useBreadcrumb = context.isUseBreadcrumb();
        this.dumpRoutes = context.isDumpRoutes();
        this.mdcLoggingKeysPattern = context.getMDCLoggingKeysPattern();
        this.useMDCLogging = context.isUseMDCLogging();
        this.basePackageScan = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBasePackageScan();
        this.messageHistory = context.isMessageHistory();
        this.allowUseOriginalMessage = context.isAllowUseOriginalMessage();
        this.logExhaustedMessageBody = context.isLogExhaustedMessageBody();
        this.version = context.getVersion();
        this.startupSummaryLevel = context.getStartupSummaryLevel();
    }

    protected static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    public CamelContext getCamelContextReference() {
        return this.reference;
    }

    public byte getStatusPhase() {
        return ((ExtendedCamelContext)this.reference.adapt(ExtendedCamelContext.class)).getStatusPhase();
    }

    public void disposeModel() {
    }

    public boolean isStarted() {
        return false;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public boolean isRunAllowed() {
        return false;
    }

    public boolean isSuspending() {
        return false;
    }

    public void build() {
        throw new UnsupportedOperationException();
    }

    public void init() {
        throw new UnsupportedOperationException();
    }

    public void suspend() {
        throw new UnsupportedOperationException();
    }

    public void resume() {
        throw new UnsupportedOperationException();
    }

    public void start() {
        this.startDate = new Date();
        LOG.info("Apache Camel {} ({}) is starting", (Object)this.getVersion(), (Object)this.getName());
        for (Route route : this.routes) {
            route.getConsumer().start();
        }
        if (LOG.isInfoEnabled()) {
            long l = System.currentTimeMillis() - this.startDate.getTime();
            LOG.info("Apache Camel {} ({}) {} routes started in {}", new Object[]{this.getVersion(), this.getName(), this.routes.size(), TimeUtils.printDuration((long)l, (boolean)true)});
        }
    }

    public void stop() {
        for (Route route : this.routes) {
            route.getConsumer().stop();
        }
    }

    public void shutdown() {
    }

    public void close() throws IOException {
        this.stop();
    }

    public void setStreamCaching(Boolean cache) {
        throw new UnsupportedOperationException();
    }

    public Boolean isStreamCaching() {
        throw new UnsupportedOperationException();
    }

    public Boolean isTracing() {
        throw new UnsupportedOperationException();
    }

    public String getTracingPattern() {
        throw new UnsupportedOperationException();
    }

    public void setTracingPattern(String tracePattern) {
        throw new UnsupportedOperationException();
    }

    public String getTracingLoggingFormat() {
        throw new UnsupportedOperationException();
    }

    public void setTracingLoggingFormat(String format) {
        throw new UnsupportedOperationException();
    }

    public Boolean isBacklogTracing() {
        throw new UnsupportedOperationException();
    }

    public void setBacklogTracingTemplates(boolean backlogTracingTemplates) {
        throw new UnsupportedOperationException();
    }

    public boolean isBacklogTracingTemplates() {
        throw new UnsupportedOperationException();
    }

    public void setTracingTemplates(boolean tracingTemplates) {
        throw new UnsupportedOperationException();
    }

    public boolean isTracingTemplates() {
        throw new UnsupportedOperationException();
    }

    public Boolean isDebugging() {
        throw new UnsupportedOperationException();
    }

    public Boolean isMessageHistory() {
        return this.messageHistory;
    }

    public Boolean isLogMask() {
        throw new UnsupportedOperationException();
    }

    public Boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public Long getDelayer() {
        throw new UnsupportedOperationException();
    }

    public void setDelayer(Long delay) {
        throw new UnsupportedOperationException();
    }

    public Boolean isAutoStartup() {
        throw new UnsupportedOperationException();
    }

    public ShutdownRoute getShutdownRoute() {
        throw new UnsupportedOperationException();
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        throw new UnsupportedOperationException();
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        throw new UnsupportedOperationException();
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        throw new UnsupportedOperationException();
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        throw new UnsupportedOperationException();
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage;
    }

    public Boolean isCaseInsensitiveHeaders() {
        throw new UnsupportedOperationException();
    }

    public void setCaseInsensitiveHeaders(Boolean caseInsensitiveHeaders) {
        throw new UnsupportedOperationException();
    }

    public Boolean isAutowiredEnabled() {
        throw new UnsupportedOperationException();
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        throw new UnsupportedOperationException();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        throw new UnsupportedOperationException();
    }

    public TypeConverterRegistry getTypeConverterRegistry() {
        return this.typeConverter;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        throw new UnsupportedOperationException();
    }

    public ModelJAXBContextFactory getModelJAXBContextFactory() {
        return this.modelJAXBContextFactory;
    }

    public void setModelJAXBContextFactory(ModelJAXBContextFactory modelJAXBContextFactory) {
        throw new UnsupportedOperationException();
    }

    public ComponentResolver getComponentResolver() {
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        throw new UnsupportedOperationException();
    }

    public ComponentNameResolver getComponentNameResolver() {
        return this.componentNameResolver;
    }

    public void setComponentNameResolver(ComponentNameResolver componentResolver) {
        throw new UnsupportedOperationException();
    }

    public LanguageResolver getLanguageResolver() {
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        throw new UnsupportedOperationException();
    }

    public DataFormatResolver getDataFormatResolver() {
        return this.dataFormatResolver;
    }

    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        throw new UnsupportedOperationException();
    }

    public HealthCheckResolver getHealthCheckResolver() {
        return this.healthCheckResolver;
    }

    public void setHealthCheckResolver(HealthCheckResolver healthCheckResolver) {
        throw new UnsupportedOperationException();
    }

    public DevConsoleResolver getDevConsoleResolver() {
        return this.devConsoleResolver;
    }

    public void setDevConsoleResolver(DevConsoleResolver devConsoleResolver) {
        throw new UnsupportedOperationException();
    }

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        throw new UnsupportedOperationException();
    }

    public <T extends CamelContext> T adapt(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)((CamelContext)type.cast(this));
        }
        throw new UnsupportedOperationException();
    }

    public <T> T getExtension(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> void setExtension(Class<T> type, T module) {
        throw new UnsupportedOperationException();
    }

    public boolean isVetoStarted() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        throw new UnsupportedOperationException();
    }

    public CamelContextNameStrategy getNameStrategy() {
        throw new UnsupportedOperationException();
    }

    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        throw new UnsupportedOperationException();
    }

    public ManagementNameStrategy getManagementNameStrategy() {
        throw new UnsupportedOperationException();
    }

    public void setManagementNameStrategy(ManagementNameStrategy nameStrategy) {
        throw new UnsupportedOperationException();
    }

    public String getManagementName() {
        throw new UnsupportedOperationException();
    }

    public void setManagementName(String name) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.version;
    }

    public ServiceStatus getStatus() {
        return ServiceStatus.Started;
    }

    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((long)delta);
    }

    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void addService(Object object) throws Exception {
    }

    public void addService(Object object, boolean stopOnShutdown) throws Exception {
    }

    public void addService(Object object, boolean stopOnShutdown, boolean forceStart) throws Exception {
    }

    public void addPrototypeService(Object object) throws Exception {
    }

    public boolean removeService(Object object) throws Exception {
        return false;
    }

    public void addBootstrap(BootstrapCloseable bootstrap) {
    }

    public List<Service> getServices() {
        return null;
    }

    public boolean hasService(Object object) {
        return false;
    }

    public <T> T hasService(Class<T> type) {
        return null;
    }

    public <T> Set<T> hasServices(Class<T> type) {
        return null;
    }

    public void deferStartService(Object object, boolean stopOnShutdown) throws Exception {
    }

    public void addStartupListener(StartupListener listener) throws Exception {
    }

    public Component hasComponent(String componentName) {
        return this.components.get(componentName);
    }

    public Component getComponent(String componentName) {
        return this.getComponent(this.name, true, true);
    }

    public Component getComponent(String name, boolean autoCreateComponents) {
        return this.getComponent(name, autoCreateComponents, true);
    }

    public Component getComponent(String name, boolean autoCreateComponents, boolean autoStart) {
        return this.components.get(name);
    }

    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        return (T)((Component)componentType.cast(this.hasComponent(name)));
    }

    public Set<String> getComponentNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    public EndpointRegistry<? extends ValueHolder<String>> getEndpointRegistry() {
        return this.endpoints;
    }

    public Endpoint getEndpoint(String uri) {
        return this.doGetEndpoint(uri, false, false);
    }

    public Endpoint getEndpoint(String uri, Map<String, Object> parameters) {
        return this.doGetEndpoint(uri, parameters, false);
    }

    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    public Collection<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.endpoints.values());
    }

    public Map<String, Endpoint> getEndpointMap() {
        throw new UnsupportedOperationException();
    }

    public Endpoint hasEndpoint(String uri) {
        return (Endpoint)this.endpoints.get((Object)NormalizedUri.newNormalizedUri((String)uri, (boolean)false));
    }

    public GlobalEndpointConfiguration getGlobalEndpointConfiguration() {
        throw new UnsupportedOperationException();
    }

    public RouteController getRouteController() {
        return this.routeController;
    }

    public void setRouteController(RouteController routeController) {
        throw new UnsupportedOperationException();
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public int getRoutesSize() {
        return this.routes.size();
    }

    public Route getRoute(String id) {
        throw new UnsupportedOperationException();
    }

    public Processor getProcessor(String id) {
        throw new UnsupportedOperationException();
    }

    public <T extends Processor> T getProcessor(String id, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public List<RoutePolicyFactory> getRoutePolicyFactories() {
        throw new UnsupportedOperationException();
    }

    public RestConfiguration getRestConfiguration() {
        throw new UnsupportedOperationException();
    }

    public void setRestConfiguration(RestConfiguration restConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void setVaultConfiguration(VaultConfiguration vaultConfiguration) {
        throw new UnsupportedOperationException();
    }

    public VaultConfiguration getVaultConfiguration() {
        throw new UnsupportedOperationException();
    }

    public RestRegistry getRestRegistry() {
        throw new UnsupportedOperationException();
    }

    public void setRestRegistry(RestRegistry restRegistry) {
        throw new UnsupportedOperationException();
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public <T> T getRegistry(Class<T> type) {
        return type.cast(this.registry);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        throw new UnsupportedOperationException();
    }

    public List<LifecycleStrategy> getLifecycleStrategies() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language resolveLanguage(String language) throws NoSuchLanguageException {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)answer).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, this.reference);
            if (answer != null) {
                CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.reference);
                if (answer instanceof Service) {
                    try {
                        this.startService((Service)answer);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    public String resolvePropertyPlaceholders(String text) {
        return this.resolvePropertyPlaceholders(text, false);
    }

    public String resolvePropertyPlaceholders(String text, boolean keepUnresolvedOptional) {
        if (text != null && text.contains("{{")) {
            return this.getPropertiesComponent().parseUri(text, keepUnresolvedOptional);
        }
        if (text != null && text.startsWith("Exchange.")) {
            String field = StringHelper.after((String)text, (String)"Exchange.");
            String constant = ExchangeConstantProvider.lookup((String)field);
            if (constant != null) {
                return constant;
            }
            throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
        }
        return text;
    }

    public PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getLanguageNames() {
        throw new UnsupportedOperationException();
    }

    public ProducerTemplate createProducerTemplate() {
        throw new UnsupportedOperationException();
    }

    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        throw new UnsupportedOperationException();
    }

    public FluentProducerTemplate createFluentProducerTemplate() {
        throw new UnsupportedOperationException();
    }

    public FluentProducerTemplate createFluentProducerTemplate(int maximumCacheSize) {
        throw new UnsupportedOperationException();
    }

    public ConsumerTemplate createConsumerTemplate() {
        throw new UnsupportedOperationException();
    }

    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        throw new UnsupportedOperationException();
    }

    public DataFormat resolveDataFormat(String name) {
        throw new UnsupportedOperationException();
    }

    public DataFormat createDataFormat(String name) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getDataFormatNames() {
        throw new UnsupportedOperationException();
    }

    public Transformer resolveTransformer(String model) {
        throw new UnsupportedOperationException();
    }

    public Transformer resolveTransformer(DataType from, DataType to) {
        throw new UnsupportedOperationException();
    }

    public TransformerRegistry getTransformerRegistry() {
        throw new UnsupportedOperationException();
    }

    public Validator resolveValidator(DataType type) {
        throw new UnsupportedOperationException();
    }

    public ValidatorRegistry getValidatorRegistry() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(Map<String, String> globalOptions) {
        throw new UnsupportedOperationException();
    }

    public String getGlobalOption(String key) {
        String value = this.getGlobalOptions().get(key);
        if (ObjectHelper.isNotEmpty((String)value)) {
            try {
                value = this.resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error getting global option: " + key, (Throwable)e);
            }
        }
        return value;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public void setClassResolver(ClassResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public ManagementStrategy getManagementStrategy() {
        return null;
    }

    public void setManagementStrategy(ManagementStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    public void disableJMX() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    public void setInflightRepository(InflightRepository repository) {
        throw new UnsupportedOperationException();
    }

    public void setTracingStandby(boolean tracingStandby) {
        throw new UnsupportedOperationException();
    }

    public boolean isTracingStandby() {
        return false;
    }

    public void setBacklogTracingStandby(boolean backlogTracingStandby) {
        throw new UnsupportedOperationException();
    }

    public boolean isBacklogTracingStandby() {
        return false;
    }

    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    public ShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        throw new UnsupportedOperationException();
    }

    public ExecutorServiceManager getExecutorServiceManager() {
        return this.executorServiceManager;
    }

    public void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        throw new UnsupportedOperationException();
    }

    public MessageHistoryFactory getMessageHistoryFactory() {
        throw new UnsupportedOperationException();
    }

    public void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        throw new UnsupportedOperationException();
    }

    public Debugger getDebugger() {
        throw new UnsupportedOperationException();
    }

    public void setDebugger(Debugger debugger) {
        throw new UnsupportedOperationException();
    }

    public Tracer getTracer() {
        throw new UnsupportedOperationException();
    }

    public void setTracer(Tracer tracer) {
        throw new UnsupportedOperationException();
    }

    public Boolean isLoadTypeConverters() {
        throw new UnsupportedOperationException();
    }

    public void setLoadTypeConverters(Boolean loadTypeConverters) {
        throw new UnsupportedOperationException();
    }

    public Boolean isLoadHealthChecks() {
        throw new UnsupportedOperationException();
    }

    public Boolean isDevConsole() {
        throw new UnsupportedOperationException();
    }

    public void setDevConsole(Boolean loadDevConsoles) {
        throw new UnsupportedOperationException();
    }

    public Boolean isModeline() {
        throw new UnsupportedOperationException();
    }

    public void setModeline(Boolean modeline) {
        throw new UnsupportedOperationException();
    }

    public void setLoadHealthChecks(Boolean loadHealthChecks) {
        throw new UnsupportedOperationException();
    }

    public Boolean isSourceLocationEnabled() {
        throw new UnsupportedOperationException();
    }

    public void setSourceLocationEnabled(Boolean sourceLocationEnabled) {
        throw new UnsupportedOperationException();
    }

    public Boolean isTypeConverterStatisticsEnabled() {
        throw new UnsupportedOperationException();
    }

    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        throw new UnsupportedOperationException();
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        throw new UnsupportedOperationException();
    }

    public Boolean isDumpRoutes() {
        return this.dumpRoutes;
    }

    public void setDumpRoutes(Boolean dumpRoutes) {
        throw new UnsupportedOperationException();
    }

    public Boolean isUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(Boolean useMDCLogging) {
        throw new UnsupportedOperationException();
    }

    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMDCLoggingKeysPattern(String pattern) {
        throw new UnsupportedOperationException();
    }

    public Boolean isUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(Boolean useDataType) {
        throw new UnsupportedOperationException();
    }

    public Boolean isUseBreadcrumb() {
        return this.useBreadcrumb;
    }

    public void setUseBreadcrumb(Boolean useBreadcrumb) {
        throw new UnsupportedOperationException();
    }

    public StreamCachingStrategy getStreamCachingStrategy() {
        throw new UnsupportedOperationException();
    }

    public void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        throw new UnsupportedOperationException();
    }

    public RuntimeEndpointRegistry getRuntimeEndpointRegistry() {
        throw new UnsupportedOperationException();
    }

    public void setRuntimeEndpointRegistry(RuntimeEndpointRegistry runtimeEndpointRegistry) {
        throw new UnsupportedOperationException();
    }

    public SSLContextParameters getSSLContextParameters() {
        throw new UnsupportedOperationException();
    }

    public void setSSLContextParameters(SSLContextParameters sslContextParameters) {
        throw new UnsupportedOperationException();
    }

    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        throw new UnsupportedOperationException();
    }

    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    public Endpoint getPrototypeEndpoint(String uri) {
        throw new UnsupportedOperationException();
    }

    public Endpoint getPrototypeEndpoint(NormalizedEndpointUri uri) {
        throw new UnsupportedOperationException();
    }

    public Endpoint hasEndpoint(NormalizedEndpointUri uri) {
        return (Endpoint)this.endpoints.get((Object)uri);
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri) {
        return this.doGetEndpoint(uri.getUri(), true, false);
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri, Map<String, Object> parameters) {
        return this.doGetEndpoint(uri.getUri(), parameters, true);
    }

    protected Endpoint doGetEndpoint(String uri, boolean normalized, boolean prototype) {
        StringHelper.notEmpty((String)uri, (String)"uri");
        if (!normalized) {
            try {
                uri = this.resolvePropertyPlaceholders(uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (!normalized) {
            uri = LightweightRuntimeCamelContext.normalizeEndpointUri(uri);
        }
        Endpoint answer = null;
        if (!prototype) {
            NormalizedUri key = NormalizedUri.newNormalizedUri((String)uri, (boolean)true);
            answer = (Endpoint)this.endpoints.get((Object)key);
        }
        if (answer == null) {
            throw new NoSuchEndpointException(uri);
        }
        return answer;
    }

    protected Endpoint doGetEndpoint(String uri, Map<String, Object> parameters, boolean normalized) {
        StringHelper.notEmpty((String)uri, (String)"uri");
        if (!normalized) {
            try {
                uri = this.resolvePropertyPlaceholders(uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (!normalized) {
            uri = LightweightRuntimeCamelContext.normalizeEndpointUri(uri);
        }
        String scheme = null;
        NormalizedUri key = NormalizedUri.newNormalizedUri((String)uri, (boolean)true);
        Endpoint answer = (Endpoint)this.endpoints.get((Object)key);
        if (answer == null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    public NormalizedEndpointUri normalizeUri(String uri) {
        try {
            uri = this.resolvePropertyPlaceholders(uri);
            return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        throw new UnsupportedOperationException();
    }

    public CamelBeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        throw new UnsupportedOperationException();
    }

    public CamelDependencyInjectionAnnotationFactory getDependencyInjectionAnnotationFactory() {
        return this.dependencyInjectionAnnotationFactory;
    }

    public void setDependencyInjectionAnnotationFactory(CamelDependencyInjectionAnnotationFactory factory) {
        throw new UnsupportedOperationException();
    }

    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        throw new UnsupportedOperationException();
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        throw new UnsupportedOperationException();
    }

    public PackageScanClassResolver getPackageScanClassResolver() {
        throw new UnsupportedOperationException();
    }

    public void setPackageScanClassResolver(PackageScanClassResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public PackageScanResourceResolver getPackageScanResourceResolver() {
        throw new UnsupportedOperationException();
    }

    public void setPackageScanResourceResolver(PackageScanResourceResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public FactoryFinder getDefaultFactoryFinder() {
        throw new UnsupportedOperationException();
    }

    public ConfigurerResolver getBootstrapConfigurerResolver() {
        throw new UnsupportedOperationException();
    }

    public void setBootstrapConfigurerResolver(ConfigurerResolver configurerResolver) {
        throw new UnsupportedOperationException();
    }

    public FactoryFinder getBootstrapFactoryFinder() {
        throw new UnsupportedOperationException();
    }

    public void setBootstrapFactoryFinder(FactoryFinder factoryFinder) {
        throw new UnsupportedOperationException();
    }

    public FactoryFinder getBootstrapFactoryFinder(String path) {
        throw new UnsupportedOperationException();
    }

    public FactoryFinder getFactoryFinder(String path) {
        throw new UnsupportedOperationException();
    }

    public FactoryFinderResolver getFactoryFinderResolver() {
        throw new UnsupportedOperationException();
    }

    public void setFactoryFinderResolver(FactoryFinderResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public ProcessorFactory getProcessorFactory() {
        return this.processorFactory;
    }

    public void setProcessorFactory(ProcessorFactory processorFactory) {
        throw new UnsupportedOperationException();
    }

    public ModelineFactory getModelineFactory() {
        return this.modelineFactory;
    }

    public void setModelineFactory(ModelineFactory modelineFactory) {
        throw new UnsupportedOperationException();
    }

    public InternalProcessorFactory getInternalProcessorFactory() {
        return this.internalProcessorFactory;
    }

    public void setInternalProcessorFactory(InternalProcessorFactory internalProcessorFactory) {
        throw new UnsupportedOperationException();
    }

    public InterceptEndpointFactory getInterceptEndpointFactory() {
        throw new UnsupportedOperationException();
    }

    public void setInterceptEndpointFactory(InterceptEndpointFactory interceptEndpointFactory) {
        throw new UnsupportedOperationException();
    }

    public RouteFactory getRouteFactory() {
        throw new UnsupportedOperationException();
    }

    public void setRouteFactory(RouteFactory routeFactory) {
        throw new UnsupportedOperationException();
    }

    public DeferServiceFactory getDeferServiceFactory() {
        throw new UnsupportedOperationException();
    }

    public void setDeferServiceFactory(DeferServiceFactory deferServiceFactory) {
        throw new UnsupportedOperationException();
    }

    public UnitOfWorkFactory getUnitOfWorkFactory() {
        return this.unitOfWorkFactory;
    }

    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        throw new UnsupportedOperationException();
    }

    public AnnotationBasedProcessorFactory getAnnotationBasedProcessorFactory() {
        throw new UnsupportedOperationException();
    }

    public void setAnnotationBasedProcessorFactory(AnnotationBasedProcessorFactory annotationBasedProcessorFactory) {
        throw new UnsupportedOperationException();
    }

    public BeanProxyFactory getBeanProxyFactory() {
        throw new UnsupportedOperationException();
    }

    public BeanProcessorFactory getBeanProcessorFactory() {
        throw new UnsupportedOperationException();
    }

    public ScheduledExecutorService getErrorHandlerExecutorService() {
        throw new UnsupportedOperationException();
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        throw new UnsupportedOperationException();
    }

    public Set<LogListener> getLogListeners() {
        throw new UnsupportedOperationException();
    }

    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        return this.asyncProcessorAwaitManager;
    }

    public void setAsyncProcessorAwaitManager(AsyncProcessorAwaitManager manager) {
        throw new UnsupportedOperationException();
    }

    public BeanIntrospection getBeanIntrospection() {
        return this.beanIntrospection;
    }

    public void setBeanIntrospection(BeanIntrospection beanIntrospection) {
        throw new UnsupportedOperationException();
    }

    public HeadersMapFactory getHeadersMapFactory() {
        return this.headersMapFactory;
    }

    public void setHeadersMapFactory(HeadersMapFactory factory) {
        throw new UnsupportedOperationException();
    }

    public CliConnectorFactory getCliConnectorFactory() {
        return this.cliConnectorFactory;
    }

    public void setCliConnectorFactory(CliConnectorFactory cliConnectorFactory) {
        throw new UnsupportedOperationException();
    }

    public ExchangeFactory getExchangeFactory() {
        return this.exchangeFactory;
    }

    public ExchangeFactoryManager getExchangeFactoryManager() {
        return this.exchangeFactoryManager;
    }

    public void setExchangeFactoryManager(ExchangeFactoryManager exchangeFactoryManager) {
        throw new UnsupportedOperationException();
    }

    public void setExchangeFactory(ExchangeFactory exchangeFactory) {
        throw new UnsupportedOperationException();
    }

    public ProcessorExchangeFactory getProcessorExchangeFactory() {
        return this.processorExchangeFactory;
    }

    public void setProcessorExchangeFactory(ProcessorExchangeFactory processorExchangeFactory) {
        throw new UnsupportedOperationException();
    }

    public ReactiveExecutor getReactiveExecutor() {
        return this.reactiveExecutor;
    }

    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        throw new UnsupportedOperationException();
    }

    public boolean isEventNotificationApplicable() {
        return this.eventNotificationApplicable;
    }

    public void setEventNotificationApplicable(boolean eventNotificationApplicable) {
        throw new UnsupportedOperationException();
    }

    public ModelToXMLDumper getModelToXMLDumper() {
        throw new UnsupportedOperationException();
    }

    public void setModelToXMLDumper(ModelToXMLDumper modelToXMLDumper) {
        throw new UnsupportedOperationException();
    }

    public RuntimeCamelCatalog getRuntimeCamelCatalog() {
        throw new UnsupportedOperationException();
    }

    public void setRuntimeCamelCatalog(RuntimeCamelCatalog runtimeCamelCatalog) {
        throw new UnsupportedOperationException();
    }

    public ConfigurerResolver getConfigurerResolver() {
        throw new UnsupportedOperationException();
    }

    public void setConfigurerResolver(ConfigurerResolver configurerResolver) {
        throw new UnsupportedOperationException();
    }

    public void addRoute(Route route) {
        throw new UnsupportedOperationException();
    }

    public void removeRoute(Route route) {
        throw new UnsupportedOperationException();
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        Class<?> clazz;
        Object instance = this.getRegistry().lookupByNameAndType(componentName, Component.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/component/").findClass(componentName).orElse(null);
            if (clazz == null) {
                instance = this.hasComponent(componentName);
                if (instance != null) {
                    clazz = instance.getClass();
                } else {
                    return null;
                }
            }
        }
        if ("ActiveMQComponent".equals(clazz.getSimpleName())) {
            return this.getComponentParameterJsonSchema("jms");
        }
        return this.getJsonSchema(clazz.getPackage().getName(), componentName);
    }

    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        Class clazz;
        Object instance = this.getRegistry().lookupByNameAndType(dataFormatName, DataFormat.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/").findClass(dataFormatName).orElse(null);
            if (clazz == null) {
                return null;
            }
        }
        return this.getJsonSchema(clazz.getPackage().getName(), dataFormatName);
    }

    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        Class clazz;
        Object instance = this.getRegistry().lookupByNameAndType(languageName, Language.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/language/").findClass(languageName).orElse(null);
            if (clazz == null) {
                return null;
            }
        }
        return this.getJsonSchema(clazz.getPackage().getName(), languageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEipParameterJsonSchema(String eipName) throws IOException {
        String[] subPackages;
        for (String sub : subPackages = new String[]{"", "/config", "/dataformat", "/language", "/loadbalancer", "/rest"}) {
            String path = "org/apache/camel/model/" + sub + "/" + eipName + ".json";
            InputStream inputStream = this.getClassResolver().loadResourceAsStream(path);
            if (inputStream == null) continue;
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonSchema(String packageName, String name) throws IOException {
        String path = packageName.replace('.', '/') + "/" + name + ".json";
        InputStream inputStream = this.getClassResolver().loadResourceAsStream(path);
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    public void setupRoutes(boolean done) {
        throw new UnsupportedOperationException();
    }

    public boolean isSetupRoutes() {
        return false;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        throw new UnsupportedOperationException();
    }

    public void setupManagement(Map<String, Object> options) {
        throw new UnsupportedOperationException();
    }

    public void addLogListener(LogListener listener) {
        throw new UnsupportedOperationException();
    }

    public RestBindingJaxbDataFormatFactory getRestBindingJaxbDataFormatFactory() {
        throw new UnsupportedOperationException();
    }

    public void setRestBindingJaxbDataFormatFactory(RestBindingJaxbDataFormatFactory restBindingJaxbDataFormatFactory) {
        throw new UnsupportedOperationException();
    }

    public XMLRoutesDefinitionLoader getXMLRoutesDefinitionLoader() {
        throw new UnsupportedOperationException();
    }

    public void setXMLRoutesDefinitionLoader(XMLRoutesDefinitionLoader xmlRoutesDefinitionLoader) {
        throw new UnsupportedOperationException();
    }

    public void setRoutesLoader(RoutesLoader routesLoader) {
        throw new UnsupportedOperationException();
    }

    public RoutesLoader getRoutesLoader() {
        throw new UnsupportedOperationException();
    }

    public ResourceLoader getResourceLoader() {
        throw new UnsupportedOperationException();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        throw new UnsupportedOperationException();
    }

    public void registerEndpointCallback(EndpointStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void removeEndpoint(Endpoint endpoint) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Collection<Endpoint> removeEndpoints(String pattern) throws Exception {
        throw new UnsupportedOperationException();
    }

    public NodeIdFactory getNodeIdFactory() {
        throw new UnsupportedOperationException();
    }

    public void setNodeIdFactory(NodeIdFactory factory) {
        throw new UnsupportedOperationException();
    }

    public void addComponent(String componentName, Component component) {
        throw new UnsupportedOperationException();
    }

    public Component removeComponent(String componentName) {
        throw new UnsupportedOperationException();
    }

    public void addRoutes(RoutesBuilder builder) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addTemplatedRoutes(RoutesBuilder builder) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addRoutesConfigurations(RouteConfigurationsBuilder builder) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean removeRoute(String routeId) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addRoutePolicyFactory(RoutePolicyFactory routePolicyFactory) {
        throw new UnsupportedOperationException();
    }

    public void setTracing(Boolean tracing) {
        throw new UnsupportedOperationException();
    }

    public void setBacklogTracing(Boolean backlogTrace) {
        throw new UnsupportedOperationException();
    }

    public void setDebugging(Boolean debugging) {
        throw new UnsupportedOperationException();
    }

    public void setMessageHistory(Boolean messageHistory) {
        throw new UnsupportedOperationException();
    }

    public void setLogMask(Boolean logMask) {
        throw new UnsupportedOperationException();
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        throw new UnsupportedOperationException();
    }

    public void setAutoStartup(Boolean autoStartup) {
        throw new UnsupportedOperationException();
    }

    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void removeRouteTemplates(String pattern) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setLightweight(boolean lightweight) {
        throw new UnsupportedOperationException();
    }

    public boolean isLightweight() {
        return true;
    }

    public String getTestExcludeRoutes() {
        return null;
    }

    public RouteController getInternalRouteController() {
        return new RouteController(){

            public LoggingLevel getLoggingLevel() {
                throw new UnsupportedOperationException();
            }

            public void setLoggingLevel(LoggingLevel loggingLevel) {
                throw new UnsupportedOperationException();
            }

            public boolean isSupervising() {
                return false;
            }

            public SupervisingRouteController supervising() {
                throw new UnsupportedOperationException();
            }

            public <T extends RouteController> T adapt(Class<T> type) {
                return (T)((RouteController)type.cast(this));
            }

            public Collection<Route> getControlledRoutes() {
                return LightweightRuntimeCamelContext.this.routes;
            }

            public void startAllRoutes() throws Exception {
                throw new UnsupportedOperationException();
            }

            public void stopAllRoutes() throws Exception {
                throw new UnsupportedOperationException();
            }

            public void removeAllRoutes() throws Exception {
                throw new UnsupportedOperationException();
            }

            public boolean isStartingRoutes() {
                return false;
            }

            public void reloadAllRoutes() throws Exception {
                throw new UnsupportedOperationException();
            }

            public boolean isReloadingRoutes() {
                return false;
            }

            public ServiceStatus getRouteStatus(String routeId) {
                return ServiceStatus.Started;
            }

            public void startRoute(String routeId) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void stopRoute(String routeId) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void stopRoute(String routeId, Throwable cause) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
                throw new UnsupportedOperationException();
            }

            public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void suspendRoute(String routeId) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void resumeRoute(String routeId) throws Exception {
                throw new UnsupportedOperationException();
            }

            public CamelContext getCamelContext() {
                throw new UnsupportedOperationException();
            }

            public void setCamelContext(CamelContext camelContext) {
                throw new UnsupportedOperationException();
            }

            public void start() {
                throw new UnsupportedOperationException();
            }

            public void stop() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public UriFactoryResolver getUriFactoryResolver() {
        throw new UnsupportedOperationException();
    }

    public void setUriFactoryResolver(UriFactoryResolver uriFactoryResolver) {
        throw new UnsupportedOperationException();
    }

    public EndpointUriFactory getEndpointUriFactory(String scheme) {
        throw new UnsupportedOperationException();
    }

    public StartupStepRecorder getStartupStepRecorder() {
        throw new UnsupportedOperationException();
    }

    public void setStartupStepRecorder(StartupStepRecorder startupStepRecorder) {
        throw new UnsupportedOperationException();
    }

    public PeriodTaskResolver getPeriodTaskResolver() {
        return this.periodTaskResolver;
    }

    public void setPeriodTaskScheduler(PeriodTaskScheduler periodTaskScheduler) {
        throw new UnsupportedOperationException();
    }

    public PeriodTaskScheduler getPeriodTaskScheduler() {
        return this.periodTaskScheduler;
    }

    public void setPeriodTaskResolver(PeriodTaskResolver periodTaskResolver) {
        throw new UnsupportedOperationException();
    }

    private void startService(Service service) throws Exception {
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)service;
            this.addStartupListener(listener);
        }
        CamelContextAware.trySetCamelContext((Object)service, (CamelContext)this.reference);
        service.start();
    }
}

