/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.detect.CalledMethods;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class UncallableMethodOfAnonymousClass
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    boolean isInnerClass = false;

    public UncallableMethodOfAnonymousClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.isInnerClass = false;
        String name = this.getClassName();
        int i = name.lastIndexOf(36);
        if (i >= 0 && i + 1 < name.length()) {
            this.isInnerClass = Character.isDigit(name.charAt(i + 1));
        }
    }

    boolean definedInThisClassOrSuper(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        Method[] arr$ = clazz.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            if (!method.equals(m.getName() + ":" + m.getSignature())) continue;
            return true;
        }
        return this.definedInSuperClassOrInterface(clazz, method);
    }

    boolean definedInSuperClassOrInterface(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        JavaClass superClass = clazz.getSuperClass();
        if (this.definedInThisClassOrSuper(superClass, method)) {
            return true;
        }
        JavaClass[] arr$ = clazz.getInterfaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JavaClass i = arr$[i$];
            if (!this.definedInThisClassOrSuper(i, method)) continue;
            return true;
        }
        return false;
    }

    public void visit(Method obj) {
        try {
            if (!this.isInnerClass) {
                return;
            }
            if (this.getMethodName().equals("<init>")) {
                return;
            }
            if (this.getMethodName().startsWith("access$")) {
                return;
            }
            if (obj.isSynthetic()) {
                return;
            }
            if (obj.isPrivate()) {
                return;
            }
            JavaClass clazz = this.getThisClass();
            XMethod xmethod = XFactory.createXMethod((JavaClass)clazz, (Method)obj);
            if (!CalledMethods.isCalled(xmethod) && !this.definedInSuperClassOrInterface(clazz, obj.getName() + ":" + obj.getSignature())) {
                this.bugReporter.reportBug(new BugInstance("UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS", 2).addClassAndMethod((PreorderVisitor)this));
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }
}

