/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.okhttp.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.okhttp.client.OkHttpRestfulClient;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;

public class OkHttpRestfulClientFactory
extends RestfulClientFactory {
    private Call.Factory myNativeClient;

    public OkHttpRestfulClientFactory() {
    }

    public OkHttpRestfulClientFactory(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    protected IHttpClient getHttpClient(String theServerBase) {
        return this.getHttpClient(new StringBuilder(theServerBase), null, null, null, null);
    }

    protected void resetHttpClient() {
        this.myNativeClient = null;
    }

    public synchronized Call.Factory getNativeClient() {
        if (this.myNativeClient == null) {
            this.myNativeClient = new OkHttpClient().newBuilder().connectTimeout((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(5, (long)this.getConnectionTimeToLive(), TimeUnit.MILLISECONDS)).readTimeout((long)this.getSocketTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.getSocketTimeout(), TimeUnit.MILLISECONDS).build();
        }
        return this.myNativeClient;
    }

    public IHttpClient getHttpClient(StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        return new OkHttpRestfulClient(this.getNativeClient(), theUrl, theIfNoneExistParams, theIfNoneExistString, theRequestType, theHeaders);
    }

    public void setHttpClient(Object okHttpClient) {
        this.myNativeClient = (Call.Factory)okHttpClient;
    }

    public void setProxy(String theHost, Integer thePort) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(theHost, (int)thePort));
        OkHttpClient.Builder builder = ((OkHttpClient)this.getNativeClient()).newBuilder().proxy(proxy);
        this.setHttpClient(builder.build());
    }
}

