/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.okhttp.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.okhttp.client.OkHttpRestfulRequest;
import ca.uhn.fhir.okhttp.utils.UrlStringUtils;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.HttpClientUtil;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class OkHttpRestfulClient
implements IHttpClient {
    private Call.Factory myClient;
    private StringBuilder myUrl;
    private Map<String, List<String>> myIfNoneExistParams;
    private String myIfNoneExistString;
    private RequestTypeEnum myRequestType;
    private List<Header> myHeaders;
    private OkHttpRestfulRequest myRequest;

    public OkHttpRestfulClient(Call.Factory theClient, StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        this.myClient = theClient;
        this.myUrl = theUrl;
        this.myIfNoneExistParams = theIfNoneExistParams;
        this.myIfNoneExistString = theIfNoneExistString;
        this.myRequestType = theRequestType;
        this.myHeaders = theHeaders;
    }

    public IHttpRequest createByteRequest(FhirContext theContext, String theContents, String theContentType, EncodingEnum theEncoding) {
        this.initBaseRequest(theContext, theEncoding, this.createPostBody(theContents, theContentType));
        return this.myRequest;
    }

    private void initBaseRequest(FhirContext theContext, EncodingEnum theEncoding, RequestBody body) {
        String sanitisedUrl = UrlStringUtils.withTrailingQuestionMarkRemoved(this.myUrl.toString());
        this.myRequest = new OkHttpRestfulRequest(this.myClient, sanitisedUrl, this.myRequestType, body);
        this.addHeadersToRequest(this.myRequest, theEncoding, theContext);
    }

    private RequestBody createPostBody(String theContents, String theContentType) {
        return RequestBody.create((MediaType)MediaType.parse((String)theContentType), (String)theContents);
    }

    public IHttpRequest createParamRequest(FhirContext theContext, Map<String, List<String>> theParams, EncodingEnum theEncoding) {
        this.initBaseRequest(theContext, theEncoding, this.getFormBodyFromParams(theParams));
        return this.myRequest;
    }

    private RequestBody getFormBodyFromParams(Map<String, List<String>> queryParams) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (Map.Entry<String, List<String>> paramEntry : queryParams.entrySet()) {
            for (String value : paramEntry.getValue()) {
                formBuilder.add(paramEntry.getKey(), value);
            }
        }
        return formBuilder.build();
    }

    public IHttpRequest createBinaryRequest(FhirContext theContext, IBaseBinary theBinary) {
        this.initBaseRequest(theContext, null, this.createPostBody(theBinary.getContent(), theBinary.getContentType()));
        return this.myRequest;
    }

    private RequestBody createPostBody(byte[] theContents, String theContentType) {
        return RequestBody.create((MediaType)MediaType.parse((String)theContentType), (byte[])theContents);
    }

    public IHttpRequest createGetRequest(FhirContext theContext, EncodingEnum theEncoding) {
        this.initBaseRequest(theContext, theEncoding, null);
        return this.myRequest;
    }

    private void addHeadersToRequest(OkHttpRestfulRequest theHttpRequest, EncodingEnum theEncoding, FhirContext theContext) {
        if (this.myHeaders != null) {
            for (Header next : this.myHeaders) {
                theHttpRequest.addHeader(next.getName(), next.getValue());
            }
        }
        this.addUserAgentHeader(theHttpRequest, theContext);
        MethodUtil.addAcceptHeaderToRequest((EncodingEnum)theEncoding, (IHttpRequest)theHttpRequest, (FhirContext)theContext);
        this.addIfNoneExistHeader(theHttpRequest);
    }

    private void addUserAgentHeader(OkHttpRestfulRequest theHttpRequest, FhirContext theContext) {
        theHttpRequest.addHeader("User-Agent", HttpClientUtil.createUserAgentString((FhirContext)theContext, (String)"okhttp"));
    }

    private void addIfNoneExistHeader(IHttpRequest result) {
        if (this.myIfNoneExistParams != null) {
            this.addIfNoneExistHeaderFromParams(result, this.myIfNoneExistParams);
        } else if (this.myIfNoneExistString != null) {
            this.addIfNoneExistHeaderFromString(result, this.myIfNoneExistString);
        }
    }

    private void addIfNoneExistHeaderFromString(IHttpRequest result, String ifNoneExistString) {
        StringBuilder sb = OkHttpRestfulClient.newHeaderBuilder(this.myUrl);
        boolean shouldAddQuestionMark = !UrlStringUtils.hasQuestionMark(sb);
        sb.append(shouldAddQuestionMark ? (char)'?' : '&');
        sb.append(UrlStringUtils.everythingAfterFirstQuestionMark(ifNoneExistString));
        result.addHeader("If-None-Exist", sb.toString());
    }

    private void addIfNoneExistHeaderFromParams(IHttpRequest result, Map<String, List<String>> ifNoneExistParams) {
        StringBuilder sb = OkHttpRestfulClient.newHeaderBuilder(this.myUrl);
        boolean shouldAddInitialQuestionMark = !UrlStringUtils.hasQuestionMark(sb);
        BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(ifNoneExistParams, (StringBuilder)sb, (boolean)shouldAddInitialQuestionMark);
        result.addHeader("If-None-Exist", sb.toString());
    }

    public static StringBuilder newHeaderBuilder(StringBuilder baseUrl) {
        StringBuilder sb = new StringBuilder(baseUrl);
        if (UrlStringUtils.endsWith(baseUrl, '/')) {
            UrlStringUtils.deleteLastCharacter(sb);
        }
        return sb;
    }
}

