/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.monad;

import ca.uhn.fhir.util.monad.Either;
import ca.uhn.fhir.util.monad.Either3;

public class Eithers {
    private Eithers() {
    }

    public static <L, R> Either<L, R> for2(L left, R right) {
        return left != null ? Eithers.forLeft(left) : Eithers.forRight(right);
    }

    public static <L, R> Either<L, R> forLeft(L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> forRight(R right) {
        return new Either<Object, R>(null, right);
    }

    public static <L, M, R> Either3<L, M, R> for3(L left, M middle, R right) {
        if (left != null) {
            return Eithers.forLeft3(left);
        }
        if (middle != null) {
            return Eithers.forMiddle3(middle);
        }
        return Eithers.forRight3(right);
    }

    public static <L, M, R> Either3<L, M, R> forLeft3(L left) {
        return new Either3<L, Object, Object>(left, null, null);
    }

    public static <L, M, R> Either3<L, M, R> forMiddle3(M middle) {
        return new Either3<Object, M, Object>(null, middle, null);
    }

    public static <L, M, R> Either3<L, M, R> forRight3(R right) {
        return new Either3<Object, Object, R>(null, null, right);
    }
}

