/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.monad;

import ca.uhn.fhir.util.monad.Eithers;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Either<L, R> {
    private final L left;
    private final R right;

    Either(L left, R right) {
        Preconditions.checkArgument((boolean)(left == null ^ right == null), (Object)"left and right are mutually exclusive");
        this.left = left;
        this.right = right;
    }

    public Either<R, L> swap() {
        if (this.isRight()) {
            return Eithers.forLeft(this.right);
        }
        return Eithers.forRight(this.left);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public L leftOrThrow() {
        Preconditions.checkState((boolean)this.isLeft());
        return this.left;
    }

    public R rightOrThrow() {
        Preconditions.checkState((boolean)this.isRight());
        return this.right;
    }

    public R getOrThrow() {
        return this.rightOrThrow();
    }

    public R orElse(R defaultValue) {
        if (this.isRight()) {
            return this.right;
        }
        return defaultValue;
    }

    public R orElseGet(Supplier<R> defaultSupplier) {
        if (this.isRight()) {
            return this.right;
        }
        return defaultSupplier.get();
    }

    public void forEach(Consumer<? super R> forRight) {
        Preconditions.checkNotNull(forRight);
        if (this.isRight()) {
            forRight.accept(this.right);
        }
    }

    public Either<L, R> peek(Consumer<? super R> forRight) {
        Preconditions.checkNotNull(forRight);
        if (this.isRight()) {
            forRight.accept(this.right);
        }
        return this;
    }

    public <T> Either<L, T> map(Function<? super R, ? extends T> mapRight) {
        Preconditions.checkNotNull(mapRight);
        if (this.isLeft()) {
            return this;
        }
        return Eithers.forRight(mapRight.apply(this.right));
    }

    public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, ? extends T>> flatMapRight) {
        Preconditions.checkNotNull(flatMapRight);
        if (this.isLeft()) {
            return this;
        }
        return flatMapRight.apply(this.right);
    }

    public <T> T fold(Function<? super L, ? extends T> foldLeft, Function<? super R, ? extends T> foldRight) {
        Preconditions.checkNotNull(foldLeft);
        Preconditions.checkNotNull(foldRight);
        if (this.isRight()) {
            return foldRight.apply(this.right);
        }
        return foldLeft.apply(this.left);
    }

    public <U> U transform(Function<? super Either<? super L, ? super R>, ? extends U> transform) {
        return transform.apply(this);
    }

    public Stream<R> stream() {
        if (this.isRight()) {
            return Stream.of(this.right);
        }
        return Stream.of(new Object[0]);
    }

    public Optional<R> optional() {
        if (this.isRight()) {
            return Optional.of(this.right);
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Either) {
            Either other = (Either)obj;
            return this.left == other.left && this.right == other.right || this.left != null && other.left != null && this.left.equals(other.left) || this.right != null && other.right != null && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        if (this.left != null) {
            return this.left.hashCode();
        }
        return this.right.hashCode();
    }
}

