/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.TimeoutException;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutManager {
    private static final Logger ourLog = LoggerFactory.getLogger(TimeoutManager.class);
    private final StopWatch myStopWatch = new StopWatch();
    private final String myServiceName;
    private final Duration myWarningTimeout;
    private final Duration myErrorTimeout;
    private boolean warned = false;
    private boolean errored = false;

    public TimeoutManager(String theServiceName, Duration theWarningTimeout, Duration theErrorTimeout) {
        this.myServiceName = theServiceName;
        this.myWarningTimeout = theWarningTimeout;
        this.myErrorTimeout = theErrorTimeout;
    }

    public boolean checkTimeout() {
        boolean retval = false;
        if (this.myStopWatch.getMillis() > this.myWarningTimeout.toMillis() && !this.warned) {
            ourLog.warn(this.myServiceName + " has run for {}", (Object)this.myStopWatch);
            this.warned = true;
            retval = true;
        }
        if (this.myStopWatch.getMillis() > this.myErrorTimeout.toMillis() && !this.errored) {
            if (HapiSystemProperties.isUnitTestModeEnabled()) {
                throw new TimeoutException(Msg.code(2133) + this.myServiceName + " timed out after running for " + String.valueOf(this.myStopWatch));
            }
            ourLog.error(this.myServiceName + " has run for {}", (Object)this.myStopWatch);
            this.errored = true;
            retval = true;
        }
        return retval;
    }

    @VisibleForTesting
    void addTimeForUnitTest(Duration theDuration) {
        StopWatch.setNowForUnitTest(this.myStopWatch.getStartedDate().getTime() + theDuration.toMillis());
    }
}

