/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.executor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IBaseInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IBaseInterceptorService;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ReflectionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInterceptorService<POINTCUT extends Enum<POINTCUT>>
implements IBaseInterceptorService<POINTCUT>,
IBaseInterceptorBroadcaster<POINTCUT> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseInterceptorService.class);
    private static final AttributeKey<String> OTEL_INTERCEPTOR_POINTCUT_NAME_ATT_KEY = AttributeKey.stringKey((String)"hapifhir.interceptor.pointcut_name");
    private static final AttributeKey<String> OTEL_INTERCEPTOR_CLASS_NAME_ATT_KEY = AttributeKey.stringKey((String)"hapifhir.interceptor.class_name");
    private static final AttributeKey<String> OTEL_INTERCEPTOR_METHOD_NAME_ATT_KEY = AttributeKey.stringKey((String)"hapifhir.interceptor.method_name");
    private final List<Object> myInterceptors = new ArrayList<Object>();
    private final ListMultimap<POINTCUT, IBaseInterceptorBroadcaster.IInvoker> myGlobalInvokers = ArrayListMultimap.create();
    private final ListMultimap<POINTCUT, IBaseInterceptorBroadcaster.IInvoker> myAnonymousInvokers = ArrayListMultimap.create();
    private final Object myRegistryMutex = new Object();
    private final Class<POINTCUT> myPointcutType;
    private volatile EnumSet<POINTCUT> myRegisteredPointcuts;
    private boolean myWarnOnInterceptorWithNoHooks = true;

    public BaseInterceptorService(Class<POINTCUT> thePointcutType) {
        this(thePointcutType, "default");
    }

    @Deprecated(since="8.0.0", forRemoval=true)
    public BaseInterceptorService(Class<POINTCUT> thePointcutType, String theName) {
        this.myPointcutType = thePointcutType;
        this.rebuildRegisteredPointcutSet();
    }

    public void setWarnOnInterceptorWithNoHooks(boolean theWarnOnInterceptorWithNoHooks) {
        this.myWarnOnInterceptorWithNoHooks = theWarnOnInterceptorWithNoHooks;
    }

    @VisibleForTesting
    List<Object> getGlobalInterceptorsForUnitTest() {
        return this.myInterceptors;
    }

    @Deprecated(since="8.0.0", forRemoval=true)
    public void setName(String theName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAnonymousInterceptor(POINTCUT thePointcut, Object theInterceptor, BaseInvoker theInvoker) {
        Validate.notNull(thePointcut, (String)"thePointcut must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theInterceptor, (String)"theInterceptor must not be null", (Object[])new Object[0]);
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.myAnonymousInvokers.put(thePointcut, (Object)theInvoker);
            if (!this.isInterceptorAlreadyRegistered(theInterceptor)) {
                this.myInterceptors.add(theInterceptor);
            }
            this.rebuildRegisteredPointcutSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllRegisteredInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            ArrayList<Object> retVal = new ArrayList<Object>(this.myInterceptors);
            return Collections.unmodifiableList(retVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void unregisterAllInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.unregisterInterceptors(this.myAnonymousInvokers.values());
            this.unregisterInterceptors(this.myGlobalInvokers.values());
            this.unregisterInterceptors(this.myInterceptors);
        }
    }

    @Override
    public void unregisterInterceptors(@Nullable Collection<?> theInterceptors) {
        if (theInterceptors != null) {
            new ArrayList(theInterceptors).forEach(this::unregisterInterceptor);
        }
    }

    @Override
    public void registerInterceptors(@Nullable Collection<?> theInterceptors) {
        if (theInterceptors != null) {
            theInterceptors.forEach(this::registerInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllAnonymousInterceptors() {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            this.unregisterInterceptorsIf(t -> true, this.myAnonymousInvokers);
        }
    }

    @Override
    public void unregisterInterceptorsIf(Predicate<Object> theShouldUnregisterFunction) {
        this.unregisterInterceptorsIf(theShouldUnregisterFunction, this.myGlobalInvokers);
        this.unregisterInterceptorsIf(theShouldUnregisterFunction, this.myAnonymousInvokers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInterceptorsIf(Predicate<Object> theShouldUnregisterFunction, ListMultimap<POINTCUT, IBaseInterceptorBroadcaster.IInvoker> theGlobalInvokers) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            for (Map.Entry nextInvoker : new ArrayList(theGlobalInvokers.entries())) {
                if (!theShouldUnregisterFunction.test(((IBaseInterceptorBroadcaster.IInvoker)nextInvoker.getValue()).getInterceptor())) continue;
                this.unregisterInterceptor(((IBaseInterceptorBroadcaster.IInvoker)nextInvoker.getValue()).getInterceptor());
            }
            this.rebuildRegisteredPointcutSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            if (this.isInterceptorAlreadyRegistered(theInterceptor)) {
                return false;
            }
            List<HookInvoker> addedInvokers = this.scanInterceptorAndAddToInvokerMultimap(theInterceptor, this.myGlobalInvokers);
            if (addedInvokers.isEmpty()) {
                if (this.myWarnOnInterceptorWithNoHooks) {
                    ourLog.warn("Interceptor registered with no valid hooks - Type was: {}", (Object)theInterceptor.getClass().getName());
                }
                return false;
            }
            this.myInterceptors.add(theInterceptor);
            this.sortByOrderAnnotation(this.myInterceptors);
            this.rebuildRegisteredPointcutSet();
            return true;
        }
    }

    private void rebuildRegisteredPointcutSet() {
        EnumSet<POINTCUT> registeredPointcuts = EnumSet.noneOf(this.myPointcutType);
        registeredPointcuts.addAll(this.myAnonymousInvokers.keySet());
        registeredPointcuts.addAll(this.myGlobalInvokers.keySet());
        this.myRegisteredPointcuts = registeredPointcuts;
    }

    private boolean isInterceptorAlreadyRegistered(Object theInterceptor) {
        for (Object next : this.myInterceptors) {
            if (next != theInterceptor) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterInterceptor(Object theInterceptor) {
        Object object = this.myRegistryMutex;
        synchronized (object) {
            boolean removed = this.myInterceptors.removeIf(t -> t == theInterceptor);
            removed |= this.myGlobalInvokers.entries().removeIf(t -> ((IBaseInterceptorBroadcaster.IInvoker)t.getValue()).getInterceptor() == theInterceptor);
            this.rebuildRegisteredPointcutSet();
            return removed |= this.myAnonymousInvokers.entries().removeIf(t -> ((IBaseInterceptorBroadcaster.IInvoker)t.getValue()).getInterceptor() == theInterceptor);
        }
    }

    private void sortByOrderAnnotation(List<Object> theObjects) {
        IdentityHashMap<Object, Integer> interceptorToOrder = new IdentityHashMap<Object, Integer>();
        for (Object next : theObjects) {
            Interceptor orderAnnotation = next.getClass().getAnnotation(Interceptor.class);
            int order = orderAnnotation != null ? orderAnnotation.order() : 0;
            interceptorToOrder.put(next, order);
        }
        theObjects.sort((a, b) -> {
            Integer orderA = (Integer)interceptorToOrder.get(a);
            Integer orderB = (Integer)interceptorToOrder.get(b);
            return orderA - orderB;
        });
    }

    @Override
    public Object callHooksAndReturnObject(POINTCUT thePointcut, HookParams theParams) {
        assert (BaseInterceptorService.haveAppropriateParams((IPointcut)thePointcut, theParams));
        assert (((IPointcut)thePointcut).getReturnType() != Void.TYPE);
        return this.doCallHooks(thePointcut, theParams);
    }

    @Override
    public boolean hasHooks(POINTCUT thePointcut) {
        return this.myRegisteredPointcuts.contains(thePointcut);
    }

    protected Class<?> getBooleanReturnType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean callHooks(POINTCUT thePointcut, HookParams theParams) {
        assert (BaseInterceptorService.haveAppropriateParams((IPointcut)thePointcut, theParams));
        assert (((IPointcut)thePointcut).getReturnType() == Void.TYPE || ((IPointcut)thePointcut).getReturnType() == this.getBooleanReturnType());
        Object retValObj = this.doCallHooks(thePointcut, theParams);
        retValObj = ObjectUtils.defaultIfNull((Object)retValObj, (Object)true);
        return (Boolean)retValObj;
    }

    private Object doCallHooks(POINTCUT thePointcut, HookParams theParams) {
        List<IBaseInterceptorBroadcaster.IInvoker> invokers = this.getInvokersForPointcut(thePointcut);
        return BaseInterceptorService.callInvokers((IPointcut)thePointcut, theParams, invokers);
    }

    @VisibleForTesting
    List<Object> getInterceptorsWithInvokersForPointcut(POINTCUT thePointcut) {
        return this.getInvokersForPointcut(thePointcut).stream().map(IBaseInterceptorBroadcaster.IInvoker::getInterceptor).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IBaseInterceptorBroadcaster.IInvoker> getInvokersForPointcut(POINTCUT thePointcut) {
        List<IBaseInterceptorBroadcaster.IInvoker> invokers;
        Object object = this.myRegistryMutex;
        synchronized (object) {
            List globalInvokers = this.myGlobalInvokers.get(thePointcut);
            List anonymousInvokers = this.myAnonymousInvokers.get(thePointcut);
            invokers = BaseInterceptorService.union(Arrays.asList(globalInvokers, anonymousInvokers));
        }
        return invokers;
    }

    public static boolean haveAppropriateParams(IPointcut thePointcut, HookParams theParams) {
        if (theParams.getParamsForType().values().size() != thePointcut.getParameterTypes().size()) {
            throw new IllegalArgumentException(Msg.code(1909) + String.format("Wrong number of params for pointcut %s - Wanted %s but found %s", thePointcut.name(), BaseInterceptorService.toErrorString(thePointcut.getParameterTypes()), theParams.getParamsForType().values().stream().map(t -> t != null ? t.getClass().getSimpleName() : "null").sorted().collect(Collectors.toList())));
        }
        ArrayList<String> wantedTypes = new ArrayList<String>(thePointcut.getParameterTypes());
        ListMultimap<Class<?>, Object> givenTypes = theParams.getParamsForType();
        for (Class nextTypeClass : givenTypes.keySet()) {
            String nextTypeName = nextTypeClass.getName();
            for (Object nextParamValue : givenTypes.get((Object)nextTypeClass)) {
                Validate.isTrue((nextParamValue == null || nextTypeClass.isAssignableFrom(nextParamValue.getClass()) ? 1 : 0) != 0, (String)"Invalid params for pointcut %s - %s is not of type %s", (Object[])new Object[]{thePointcut.name(), nextParamValue != null ? nextParamValue.getClass() : "null", nextTypeClass});
                Validate.isTrue((boolean)wantedTypes.remove(nextTypeName), (String)"Invalid params for pointcut %s - Wanted %s but found %s", (Object[])new Object[]{thePointcut.name(), BaseInterceptorService.toErrorString(thePointcut.getParameterTypes()), nextTypeName});
            }
        }
        return true;
    }

    private List<HookInvoker> scanInterceptorAndAddToInvokerMultimap(Object theInterceptor, ListMultimap<POINTCUT, IBaseInterceptorBroadcaster.IInvoker> theInvokers) {
        Class<?> interceptorClass = theInterceptor.getClass();
        int typeOrder = BaseInterceptorService.determineOrder(interceptorClass);
        List<HookInvoker> addedInvokers = this.scanInterceptorForHookMethods(theInterceptor, typeOrder);
        addedInvokers.stream().filter(t -> Pointcut.INTERCEPTOR_REGISTERED.equals(t.getPointcut())).forEach(t -> t.invoke(new HookParams()));
        for (HookInvoker nextAddedHook : addedInvokers) {
            Object nextPointcut = nextAddedHook.getPointcut();
            if (((Enum)nextPointcut).equals(Pointcut.INTERCEPTOR_REGISTERED)) continue;
            theInvokers.put(nextPointcut, (Object)nextAddedHook);
        }
        for (Enum nextPointcut : theInvokers.keys()) {
            List nextInvokerList = theInvokers.get((Object)nextPointcut);
            nextInvokerList.sort(Comparator.naturalOrder());
        }
        return addedInvokers;
    }

    private List<HookInvoker> scanInterceptorForHookMethods(Object theInterceptor, int theTypeOrder) {
        ArrayList<HookInvoker> retVal = new ArrayList<HookInvoker>();
        for (Method nextMethod : ReflectionUtil.getDeclaredMethods(theInterceptor.getClass(), true)) {
            Optional<HookDescriptor> hook = this.scanForHook(nextMethod);
            if (!hook.isPresent()) continue;
            int methodOrder = theTypeOrder;
            int methodOrderAnnotation = hook.get().getOrder();
            if (methodOrderAnnotation != 0) {
                methodOrder = methodOrderAnnotation;
            }
            retVal.add(new HookInvoker(hook.get(), theInterceptor, nextMethod, methodOrder));
        }
        return retVal;
    }

    protected abstract Optional<HookDescriptor> scanForHook(Method var1);

    public static Object callInvokers(IPointcut thePointcut, HookParams theParams, List<IBaseInterceptorBroadcaster.IInvoker> invokers) {
        Object retVal = null;
        for (IBaseInterceptorBroadcaster.IInvoker nextInvoker : invokers) {
            Object nextOutcome = nextInvoker.invoke(theParams);
            Class<?> pointcutReturnType = thePointcut.getReturnType();
            if (pointcutReturnType.equals(thePointcut.getBooleanReturnTypeForEnum())) {
                Boolean nextOutcomeAsBoolean = (Boolean)nextOutcome;
                if (Boolean.FALSE.equals(nextOutcomeAsBoolean)) {
                    ourLog.trace("callHooks({}) for invoker({}) returned false", (Object)thePointcut, (Object)nextInvoker);
                    retVal = false;
                    break;
                }
                retVal = true;
                continue;
            }
            if (pointcutReturnType.equals(Void.TYPE) || nextOutcome == null) continue;
            retVal = nextOutcome;
            break;
        }
        return retVal;
    }

    public static List<IBaseInterceptorBroadcaster.IInvoker> union(List<List<IBaseInterceptorBroadcaster.IInvoker>> theInvokersLists) {
        List<IBaseInterceptorBroadcaster.IInvoker> retVal;
        List<IBaseInterceptorBroadcaster.IInvoker> haveOne = null;
        boolean haveMultiple = false;
        for (List<IBaseInterceptorBroadcaster.IInvoker> nextInvokerList : theInvokersLists) {
            if (nextInvokerList == null || nextInvokerList.isEmpty()) continue;
            if (haveOne == null) {
                haveOne = nextInvokerList;
                continue;
            }
            haveMultiple = true;
        }
        if (haveOne == null) {
            return Collections.emptyList();
        }
        if (!haveMultiple) {
            if (haveOne == theInvokersLists.get(0)) {
                retVal = haveOne;
            } else {
                retVal = new ArrayList<IBaseInterceptorBroadcaster.IInvoker>(haveOne);
                retVal.sort(Comparator.naturalOrder());
            }
        } else {
            int totalSize = 0;
            for (List<IBaseInterceptorBroadcaster.IInvoker> list : theInvokersLists) {
                totalSize += list.size();
            }
            retVal = new ArrayList<IBaseInterceptorBroadcaster.IInvoker>(totalSize);
            for (List<IBaseInterceptorBroadcaster.IInvoker> list : theInvokersLists) {
                retVal.addAll(list);
            }
            retVal.sort(Comparator.naturalOrder());
        }
        return retVal;
    }

    protected static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement theObject, Class<T> theHookClass) {
        Object annotation = theObject instanceof Method ? MethodUtils.getAnnotation((Method)((Method)theObject), theHookClass, (boolean)true, (boolean)true) : theObject.getAnnotation(theHookClass);
        return Optional.ofNullable(annotation);
    }

    private static int determineOrder(Class<?> theInterceptorClass) {
        return BaseInterceptorService.findAnnotation(theInterceptorClass, Interceptor.class).map(Interceptor::order).orElse(0);
    }

    private static String toErrorString(List<String> theParameterTypes) {
        return theParameterTypes.stream().sorted().collect(Collectors.joining(","));
    }

    private class HookInvoker
    extends BaseInvoker {
        private final Method myMethod;
        private final Class<?>[] myParameterTypes;
        private final int[] myParameterIndexes;
        private final POINTCUT myPointcut;

        private HookInvoker(@Nonnull HookDescriptor theHook, @Nonnull Object theInterceptor, Method theHookMethod, int theOrder) {
            super(theInterceptor, theOrder);
            this.myPointcut = theHook.getPointcut();
            this.myParameterTypes = theHookMethod.getParameterTypes();
            this.myMethod = theHookMethod;
            Class<?> returnType = theHookMethod.getReturnType();
            if (((IPointcut)this.myPointcut).getReturnType().equals(((IPointcut)this.myPointcut).getBooleanReturnTypeForEnum())) {
                Validate.isTrue((((IPointcut)this.myPointcut).getBooleanReturnTypeForEnum().equals(returnType) || Void.TYPE.equals(returnType) ? 1 : 0) != 0, (String)"Method does not return %s or void: %s", (Object[])new Object[]{((IPointcut)this.myPointcut).getBooleanReturnTypeForEnum().getSimpleName(), theHookMethod});
            } else if (((IPointcut)this.myPointcut).getReturnType().equals(Void.TYPE)) {
                Validate.isTrue((boolean)Void.TYPE.equals(returnType), (String)"Method does not return void: %s", (Object[])new Object[]{theHookMethod});
            } else {
                Validate.isTrue((((IPointcut)this.myPointcut).getReturnType().isAssignableFrom(returnType) || Void.TYPE.equals(returnType) ? 1 : 0) != 0, (String)"Method does not return %s or void: %s", (Object[])new Object[]{((IPointcut)this.myPointcut).getReturnType(), theHookMethod});
            }
            this.myParameterIndexes = new int[this.myParameterTypes.length];
            HashMap<Class, AtomicInteger> typeToCount = new HashMap<Class, AtomicInteger>();
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                AtomicInteger counter = typeToCount.computeIfAbsent(this.myParameterTypes[i], t -> new AtomicInteger(0));
                this.myParameterIndexes[i] = counter.getAndIncrement();
            }
            this.myMethod.setAccessible(true);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("method", (Object)this.myMethod).toString();
        }

        @Override
        public String getHookDescription() {
            return this.getInterceptor().getClass().getName() + "." + this.myMethod.getName();
        }

        public POINTCUT getPointcut() {
            return this.myPointcut;
        }

        @Override
        public Object invoke(HookParams theParams) {
            Object[] args = new Object[this.myParameterTypes.length];
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                Class<?> nextParamType = this.myParameterTypes[i];
                if (nextParamType.equals(Pointcut.class)) {
                    args[i] = this.myPointcut;
                    continue;
                }
                int nextParamIndex = this.myParameterIndexes[i];
                Object nextParamValue = theParams.get(nextParamType, nextParamIndex);
                args[i] = nextParamValue;
            }
            try {
                return this.invokeMethod(args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (((IPointcut)this.myPointcut).isShouldLogAndSwallowException(targetException)) {
                    ourLog.error("Exception thrown by interceptor: " + targetException.toString(), targetException);
                    return null;
                }
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new InternalErrorException(Msg.code(1910) + "Failure invoking interceptor for pointcut(s) " + String.valueOf(this.getPointcut()), targetException);
            }
            catch (Exception e) {
                throw new InternalErrorException(Msg.code(1911) + String.valueOf(e));
            }
        }

        @WithSpan(value="hapifhir.interceptor")
        private Object invokeMethod(Object[] args) throws InvocationTargetException, IllegalAccessException {
            Span currentSpan = Span.current();
            currentSpan.setAttribute(OTEL_INTERCEPTOR_POINTCUT_NAME_ATT_KEY, (Object)((Enum)this.myPointcut).name());
            currentSpan.setAttribute(OTEL_INTERCEPTOR_CLASS_NAME_ATT_KEY, (Object)this.myMethod.getDeclaringClass().getName());
            currentSpan.setAttribute(OTEL_INTERCEPTOR_METHOD_NAME_ATT_KEY, (Object)this.myMethod.getName());
            return this.myMethod.invoke(this.getInterceptor(), args);
        }
    }

    protected class HookDescriptor {
        private final POINTCUT myPointcut;
        private final int myOrder;
        final /* synthetic */ BaseInterceptorService this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public HookDescriptor(POINTCUT thePointcut, int theOrder) {
            this.this$0 = (BaseInterceptorService)this$0;
            this.myPointcut = thePointcut;
            this.myOrder = theOrder;
        }

        POINTCUT getPointcut() {
            return this.myPointcut;
        }

        int getOrder() {
            return this.myOrder;
        }
    }

    public static abstract class BaseInvoker
    implements IBaseInterceptorBroadcaster.IInvoker {
        private final int myOrder;
        private final Object myInterceptor;

        BaseInvoker(Object theInterceptor, int theOrder) {
            this.myInterceptor = theInterceptor;
            this.myOrder = theOrder;
        }

        @Override
        public Object getInterceptor() {
            return this.myInterceptor;
        }

        @Override
        public int getOrder() {
            return this.myOrder;
        }

        @Override
        public int compareTo(IBaseInterceptorBroadcaster.IInvoker theInvoker) {
            return this.myOrder - theInvoker.getOrder();
        }
    }
}

