/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.api;

import ca.uhn.fhir.interceptor.api.IBaseInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.validation.ValidationResult;
import jakarta.annotation.Nonnull;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseConformance;

public enum Pointcut implements IPointcut
{
    INTERCEPTOR_REGISTERED(Void.TYPE, new String[0]),
    CLIENT_REQUEST(Void.TYPE, "ca.uhn.fhir.rest.client.api.IHttpRequest", "ca.uhn.fhir.rest.client.api.IRestfulClient"),
    CLIENT_RESPONSE(Void.TYPE, "ca.uhn.fhir.rest.client.api.IHttpRequest", "ca.uhn.fhir.rest.client.api.IHttpResponse", "ca.uhn.fhir.rest.client.api.IRestfulClient", "ca.uhn.fhir.rest.client.api.ClientResponseContext"),
    SERVER_CAPABILITY_STATEMENT_GENERATED(IBaseConformance.class, "org.hl7.fhir.instance.model.api.IBaseConformance", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SERVER_INCOMING_REQUEST_PRE_PROCESSED(Boolean.TYPE, "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_HANDLE_EXCEPTION(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse", "ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException"),
    SERVER_INCOMING_REQUEST_PRE_HANDLER_SELECTED(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_INCOMING_REQUEST_POST_PROCESSED(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_INCOMING_REQUEST_PRE_HANDLED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.RestOperationTypeEnum"),
    SERVER_PROVIDER_METHOD_BOUND("ca.uhn.fhir.rest.server.method.BaseMethodBinding", "ca.uhn.fhir.rest.server.method.BaseMethodBinding"),
    SERVER_PRE_PROCESS_OUTGOING_EXCEPTION(BaseServerResponseException.class, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.Throwable", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_RESPONSE(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.ResponseDetails", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_WRITER_CREATED(Writer.class, "java.io.Writer", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SERVER_OUTGOING_GRAPHQL_RESPONSE(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.String", "java.lang.String", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_FAILURE_OPERATIONOUTCOME(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "org.hl7.fhir.instance.model.api.IBaseOperationOutcome"),
    SERVER_PROCESSING_COMPLETED_NORMALLY(Void.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(Throwable.class), "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SERVER_PROCESSING_COMPLETED(Void.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(Throwable.class), "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SUBSCRIPTION_RESOURCE_MODIFIED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_RESOURCE_MATCHED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage", "ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult"),
    SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_BEFORE_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_DELIVERY_FAILED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage", "java.lang.Exception"),
    SUBSCRIPTION_AFTER_REST_HOOK_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_BEFORE_REST_HOOK_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_MESSAGE_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_BEFORE_MESSAGE_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage", "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage"),
    SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_REGISTERED(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription"),
    SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_UNREGISTERED(Void.TYPE, new String[0]),
    STORAGE_CASCADE_DELETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.api.model.DeleteConflictList", "org.hl7.fhir.instance.model.api.IBaseResource"),
    SUBSCRIPTION_TOPIC_BEFORE_PERSISTED_RESOURCE_CHECKED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_TOPIC_AFTER_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    STORAGE_PRE_AUTO_CREATE_PLACEHOLDER_REFERENCE("ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetResponse", "ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetRequest", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRE_INITIATE_BULK_EXPORT(Void.TYPE, "ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_INITIATE_BULK_EXPORT(Void.TYPE, "ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_BULK_EXPORT_RESOURCE_INCLUSION(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters", "org.hl7.fhir.instance.model.api.IBaseResource"),
    STORAGE_PRE_DELETE_EXPUNGE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.String"),
    STORAGE_PRE_DELETE_EXPUNGE_PID_LIST(Void.TYPE, "java.lang.String", "java.util.List", "java.util.concurrent.atomic.AtomicLong", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PREACCESS_RESOURCES(Void.TYPE, "ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRECHECK_FOR_CACHED_SEARCH(Boolean.TYPE, "ca.uhn.fhir.jpa.searchparam.SearchParameterMap", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESEARCH_REGISTERED(Void.TYPE, "ca.uhn.fhir.rest.server.util.ICachedSearchDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.searchparam.SearchParameterMap", "ca.uhn.fhir.interceptor.model.RequestPartitionId"),
    STORAGE_PRESHOW_RESOURCES(Void.TYPE, "ca.uhn.fhir.rest.api.server.IPreResourceShowDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESTORAGE_RESOURCE_CREATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails", "ca.uhn.fhir.interceptor.model.RequestPartitionId"),
    STORAGE_PRESTORAGE_CLIENT_ASSIGNED_ID(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails"),
    STORAGE_PRESTORAGE_RESOURCE_UPDATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_RESOURCE_DELETED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRECOMMIT_RESOURCE_CREATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails", "ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum"),
    STORAGE_PRECOMMIT_RESOURCE_UPDATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails", "ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum"),
    STORAGE_PRECOMMIT_RESOURCE_DELETED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails", "ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum"),
    STORAGE_TRANSACTION_PROCESSING(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseBundle", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_TRANSACTION_PROCESSED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseBundle", "ca.uhn.fhir.rest.api.server.storage.DeferredInterceptorBroadcasts", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_TRANSACTION_WRITE_OPERATIONS_PRE(Void.TYPE, "ca.uhn.fhir.interceptor.model.TransactionWriteOperationsDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_TRANSACTION_WRITE_OPERATIONS_POST(Void.TYPE, "ca.uhn.fhir.interceptor.model.TransactionWriteOperationsDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_DELETE_CONFLICTS("ca.uhn.fhir.jpa.delete.DeleteConflictOutcome", "ca.uhn.fhir.jpa.api.model.DeleteConflictList", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_EXPUNGE_RESOURCE(Void.TYPE, "java.util.concurrent.atomic.AtomicInteger", "org.hl7.fhir.instance.model.api.IIdType", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING(Void.TYPE, "java.util.concurrent.atomic.AtomicInteger", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_IDENTIFY_CREATE("ca.uhn.fhir.interceptor.model.RequestPartitionId", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_IDENTIFY_READ("ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails"),
    STORAGE_PARTITION_IDENTIFY_ANY("ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_CREATED(Void.TYPE, "ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_DELETED(Void.TYPE, "ca.uhn.fhir.interceptor.model.RequestPartitionId"),
    STORAGE_PARTITION_SELECTED(Void.TYPE, "ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.context.RuntimeResourceDefinition"),
    STORAGE_VERSION_CONFLICT("ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    VALIDATION_COMPLETED(ValidationResult.class, "org.hl7.fhir.instance.model.api.IBaseResource", "java.lang.String", "ca.uhn.fhir.validation.ValidationResult"),
    MDM_BEFORE_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource"),
    MDM_AFTER_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "ca.uhn.fhir.rest.server.messaging.ResourceOperationMessage", "ca.uhn.fhir.rest.server.TransactionLogMessages", "ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent"),
    MDM_POST_CREATE_LINK(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent"),
    MDM_POST_UPDATE_LINK(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent"),
    MDM_POST_MERGE_GOLDEN_RESOURCES(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmMergeEvent", "ca.uhn.fhir.mdm.model.MdmTransactionContext"),
    MDM_POST_LINK_HISTORY(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmHistoryEvent"),
    MDM_POST_NOT_DUPLICATE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmLinkEvent"),
    MDM_CLEAR(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmClearEvent"),
    MDM_SUBMIT(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.mdm.model.mdmevents.MdmSubmitEvent"),
    MDM_SUBMIT_PRE_MESSAGE_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage"),
    JPA_INDEX_EXTRACT_FULLTEXT_CONTENT("ca.uhn.fhir.jpa.searchparam.fulltext.FullTextExtractionResponse", "ca.uhn.fhir.jpa.searchparam.fulltext.FullTextExtractionRequest"),
    JPA_INDEX_EXTRACT_FULLTEXT_TEXT("ca.uhn.fhir.jpa.searchparam.fulltext.FullTextExtractionResponse", "ca.uhn.fhir.jpa.searchparam.fulltext.FullTextExtractionRequest"),
    JPA_RESOLVE_CROSS_PARTITION_REFERENCE("ca.uhn.fhir.jpa.model.cross.IResourceLookup", "ca.uhn.fhir.jpa.searchparam.extractor.CrossPartitionReferenceDetails"),
    JPA_PERFTRACE_INFO(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.StorageProcessingMessage"),
    JPA_PERFTRACE_WARNING(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.StorageProcessingMessage"),
    JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_SELECT_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_FAILED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_PASS_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_REUSING_CACHED(Boolean.TYPE, "ca.uhn.fhir.jpa.searchparam.SearchParameterMap", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    JPA_PERFTRACE_SEARCH_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_FOUND_ID(Void.TYPE, "java.lang.Integer", "java.lang.Object"),
    JPA_PERFTRACE_RAW_SQL(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.util.SqlQueryList"),
    STORAGE_BINARY_ASSIGN_BLOB_ID_PREFIX(String.class, "ca.uhn.fhir.rest.api.server.RequestDetails", "org.hl7.fhir.instance.model.api.IBaseResource"),
    STORAGE_BINARY_ASSIGN_BINARY_CONTENT_ID_PREFIX(String.class, "ca.uhn.fhir.rest.api.server.RequestDetails", "org.hl7.fhir.instance.model.api.IBaseResource"),
    STORAGE_PRESTORAGE_BATCH_JOB_CREATE(Void.TYPE, "ca.uhn.fhir.batch2.model.JobInstance", "ca.uhn.fhir.rest.api.server.RequestDetails"),
    CDS_HOOK_PREFETCH_REQUEST(Void.TYPE, "ca.uhn.hapi.fhir.cdshooks.api.json.prefetch.CdsHookPrefetchPointcutContextJson", "ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson"),
    CDS_HOOK_PREFETCH_RESPONSE(Void.TYPE, "ca.uhn.hapi.fhir.cdshooks.api.json.prefetch.CdsHookPrefetchPointcutContextJson", "ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson", "org.hl7.fhir.instance.model.api.IBaseResource"),
    CDS_HOOK_PREFETCH_FAILED(Void.TYPE, "ca.uhn.hapi.fhir.cdshooks.api.json.prefetch.CdsHookPrefetchPointcutContextJson", "ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson", "java.lang.Exception"),
    BATCH2_CHUNK_PROCESS_FILTER(IBaseInterceptorBroadcaster.IInterceptorFilterHook.class, "ca.uhn.fhir.batch2.model.JobInstance", "ca.uhn.fhir.batch2.model.WorkChunk"),
    PROVENANCE_AGENTS(Void.TYPE, "ca.uhn.fhir.jpa.model.IProvenanceAgentsPointcutParameter"),
    TEST_RB(Boolean.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(IllegalStateException.class), String.class.getName(), String.class.getName()),
    TEST_FILTER(IBaseInterceptorBroadcaster.IInterceptorFilterHook.class, String.class.getName()),
    TEST_RO(BaseServerResponseException.class, String.class.getName(), String.class.getName());

    private final List<String> myParameterTypes;
    private final Class<?> myReturnType;
    private final ExceptionHandlingSpec myExceptionHandlingSpec;

    private Pointcut(String theReturnType, String ... theParameterTypes) {
        this(Pointcut.toReturnTypeClass(theReturnType), new ExceptionHandlingSpec(), theParameterTypes);
    }

    private Pointcut(Class<?> theReturnType, ExceptionHandlingSpec theExceptionHandlingSpec, String ... theParameterTypes) {
        Validate.isTrue((!theReturnType.equals(Boolean.class) ? 1 : 0) != 0, (String)"Return type Boolean not allowed here, must be boolean", (Object[])new Object[0]);
        this.myReturnType = theReturnType;
        this.myExceptionHandlingSpec = theExceptionHandlingSpec;
        this.myParameterTypes = Collections.unmodifiableList(Arrays.asList(theParameterTypes));
    }

    private Pointcut(Class<?> theReturnType, String ... theParameterTypes) {
        this(theReturnType, new ExceptionHandlingSpec(), theParameterTypes);
    }

    @Override
    public boolean isShouldLogAndSwallowException(@Nonnull Throwable theException) {
        for (Class<? extends Throwable> next : this.myExceptionHandlingSpec.myTypesToLogAndSwallow) {
            if (!next.isAssignableFrom(theException.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Class<?> getReturnType() {
        return this.myReturnType;
    }

    @Override
    public Class<?> getBooleanReturnTypeForEnum() {
        return Boolean.TYPE;
    }

    @Override
    @Nonnull
    public List<String> getParameterTypes() {
        return this.myParameterTypes;
    }

    private static Class<?> toReturnTypeClass(String theReturnType) {
        try {
            return Class.forName(theReturnType);
        }
        catch (ClassNotFoundException theE) {
            return UnknownType.class;
        }
    }

    private static class ExceptionHandlingSpec {
        private final Set<Class<? extends Throwable>> myTypesToLogAndSwallow = new HashSet<Class<? extends Throwable>>();

        private ExceptionHandlingSpec() {
        }

        ExceptionHandlingSpec addLogAndSwallow(@Nonnull Class<? extends Throwable> theType) {
            this.myTypesToLogAndSwallow.add(theType);
            return this;
        }
    }

    private static class UnknownType {
        private UnknownType() {
        }
    }
}

