/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.util.CollectionUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class ParserOptions {
    private boolean myStripVersionsFromReferences = true;
    private Set<String> myDontStripVersionsFromReferencesAtPaths = Collections.emptySet();
    private boolean myOverrideResourceIdWithBundleEntryFullUrl = true;
    private boolean myAutoContainReferenceTargetsWithNoId = true;
    private Set<String> myEncodeElementsForSummaryMode = null;
    private Set<String> myDontEncodeElementsForSummaryMode = null;

    public boolean isAutoContainReferenceTargetsWithNoId() {
        return this.myAutoContainReferenceTargetsWithNoId;
    }

    public void setAutoContainReferenceTargetsWithNoId(boolean theAllowAutoContainedReferences) {
        this.myAutoContainReferenceTargetsWithNoId = theAllowAutoContainedReferences;
    }

    public boolean isStripVersionsFromReferences() {
        return this.myStripVersionsFromReferences;
    }

    public ParserOptions setStripVersionsFromReferences(boolean theStripVersionsFromReferences) {
        this.myStripVersionsFromReferences = theStripVersionsFromReferences;
        return this;
    }

    public Set<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.myDontStripVersionsFromReferencesAtPaths;
    }

    public Set<String> getDontStripVersionsFromReferencesAtPathsByResourceType(String theResourceType) {
        Validate.notEmpty((CharSequence)theResourceType, (String)"theResourceType must not be null or empty", (Object[])new Object[0]);
        return this.myDontStripVersionsFromReferencesAtPaths.stream().filter(referencePath -> referencePath.startsWith(theResourceType + ".")).collect(Collectors.toSet());
    }

    public ParserOptions setDontStripVersionsFromReferencesAtPaths(String ... thePaths) {
        if (thePaths == null) {
            this.setDontStripVersionsFromReferencesAtPaths((Collection<String>)null);
        } else {
            this.setDontStripVersionsFromReferencesAtPaths(CollectionUtil.newSet(thePaths));
        }
        return this;
    }

    public ParserOptions setDontStripVersionsFromReferencesAtPaths(Collection<String> thePaths) {
        this.myDontStripVersionsFromReferencesAtPaths = thePaths == null ? Collections.emptySet() : (thePaths instanceof HashSet ? (Set<Object>)((HashSet)thePaths).clone() : new HashSet<String>(thePaths));
        return this;
    }

    public boolean isOverrideResourceIdWithBundleEntryFullUrl() {
        return this.myOverrideResourceIdWithBundleEntryFullUrl;
    }

    public ParserOptions setOverrideResourceIdWithBundleEntryFullUrl(boolean theOverrideResourceIdWithBundleEntryFullUrl) {
        this.myOverrideResourceIdWithBundleEntryFullUrl = theOverrideResourceIdWithBundleEntryFullUrl;
        return this;
    }

    @Nonnull
    public ParserOptions setEncodeElementsForSummaryMode(String ... theEncodeElements) {
        return this.setEncodeElementsForSummaryMode(CollectionUtil.newSet(theEncodeElements));
    }

    @Nonnull
    public ParserOptions setEncodeElementsForSummaryMode(@Nullable Collection<String> theEncodeElements) {
        HashSet<String> encodeElements = null;
        if (theEncodeElements != null && !theEncodeElements.isEmpty()) {
            encodeElements = new HashSet<String>(theEncodeElements);
        }
        this.myEncodeElementsForSummaryMode = encodeElements;
        return this;
    }

    @Nullable
    public Set<String> getEncodeElementsForSummaryMode() {
        return this.myEncodeElementsForSummaryMode;
    }

    @Nonnull
    public ParserOptions setDontEncodeElementsForSummaryMode(String ... theEncodeElements) {
        return this.setDontEncodeElementsForSummaryMode(CollectionUtil.newSet(theEncodeElements));
    }

    @Nonnull
    public ParserOptions setDontEncodeElementsForSummaryMode(@Nullable Collection<String> theDontEncodeElements) {
        HashSet<String> dontEncodeElements = null;
        if (theDontEncodeElements != null && !theDontEncodeElements.isEmpty()) {
            dontEncodeElements = new HashSet<String>(theDontEncodeElements);
        }
        this.myDontEncodeElementsForSummaryMode = dontEncodeElements;
        return this;
    }

    @Nullable
    public Set<String> getDontEncodeElementsForSummaryMode() {
        return this.myDontEncodeElementsForSummaryMode;
    }
}

